/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.engine;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import org.w3c.dom.Document;
import uk.org.ogsadai.common.FIFOQueue;
import uk.org.ogsadai.common.MemoryUtilities;
import uk.org.ogsadai.common.Queue;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.msgs.MessageID;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.engine.Engine;
import uk.org.ogsadai.engine.EngineConfiguration;
import uk.org.ogsadai.engine.ProcessingStatus;
import uk.org.ogsadai.engine.Request;
import uk.org.ogsadai.engine.RequestAuthorizationException;
import uk.org.ogsadai.engine.RequestContext;
import uk.org.ogsadai.engine.RequestExecutionException;
import uk.org.ogsadai.engine.RequestMaximumReachedException;
import uk.org.ogsadai.engine.RequestSpecificationException;
import uk.org.ogsadai.engine.ResponseBuilder;
import uk.org.ogsadai.engine.StatusToStatusObserver;
import uk.org.ogsadai.sessions.SessionID;
import uk.org.ogsadai.sessions.SessionJoinDeniedException;
import uk.org.ogsadai.sessions.SessionJoinException;
import uk.org.ogsadai.sessions.SessionNotFoundException;
import uk.org.ogsadai.sessions.SessionReleaseException;

public class RequestEngine
extends Observable
implements Engine {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";
    private static final DAILogger LOG = DAILogger.getLogger(RequestEngine.class);
    private final EngineConfiguration mConfiguration;
    private final HashSet mProcessingPool;
    private final Queue mQueue;
    private final boolean mHasQueue;
    private boolean mProgressMonitorEnabled;
    private final Observer mProgressMonitor = new Observer(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(Observable status, Object request) {
            if (!RequestEngine.this.mProgressMonitorEnabled) {
                return;
            }
            if (((ProcessingStatus)status).isStopped()) {
                RequestEngine.this.releaseSession((Request)request);
                HashSet hashSet = RequestEngine.this.mProcessingPool;
                synchronized (hashSet) {
                    RequestEngine.this.mProcessingPool.remove(request);
                    RequestEngine.this.fillUpPool();
                    RequestEngine.this.setChanged();
                    RequestEngine.this.notifyObservers(new Integer(RequestEngine.this.activeLoad()));
                }
            }
        }
    };

    public RequestEngine(EngineConfiguration config) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Constructing Request Engine.");
        }
        this.mConfiguration = config;
        this.mQueue = new FIFOQueue(Math.max(1, this.mConfiguration.getMaxQueueLength()));
        this.mHasQueue = this.mConfiguration.getMaxQueueLength() > 0;
        this.mProcessingPool = new HashSet(this.mConfiguration.getMaxRequests());
        this.mProgressMonitorEnabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(Request request, RequestContext context, ResponseBuilder builder) throws RequestAuthorizationException, RequestSpecificationException, RequestExecutionException {
        if (request == null) {
            throw new IllegalArgumentException("The request argument must not be null.");
        }
        if (!request.getStatus().isUnstarted()) {
            throw new IllegalArgumentException("The engine can only accept requests that are unstarted.");
        }
        MemoryUtilities.logMemoryUsage(LOG);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Engine received the following request: " + request);
        }
        context.setRequest(request);
        this.joinSession(request);
        request.initialise(this.mConfiguration, context, builder);
        if (request.getStatus().isInitialising()) {
            boolean requestAdmitted = false;
            HashSet hashSet = this.mProcessingPool;
            synchronized (hashSet) {
                Queue queue = this.mQueue;
                synchronized (queue) {
                    this.fillUpPool();
                    requestAdmitted = this.mHasQueue && this.processingPoolFull() ? this.mQueue.offer(request) : this.process(request);
                }
            }
            if (!requestAdmitted) {
                throw new RequestSpecificationException(new RequestMaximumReachedException(this.mConfiguration.getMaxRequests(), this.mConfiguration.getMaxQueueLength()));
            }
        }
        this.setChanged();
        this.notifyObservers(new Integer(this.activeLoad()));
        request.waitForResponse();
        MemoryUtilities.logMemoryUsage(LOG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void terminate() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("The engine has received a terminate call.");
        }
        this.mProgressMonitorEnabled = false;
        HashSet hashSet = this.mProcessingPool;
        synchronized (hashSet) {
            Queue queue = this.mQueue;
            synchronized (queue) {
                Request r;
                Iterator i = this.mProcessingPool.iterator();
                while (i.hasNext()) {
                    r = (Request)i.next();
                    r.getStatus().deleteObserver(this.mProgressMonitor);
                    r.terminate();
                    this.releaseSession(r);
                }
                this.mProcessingPool.clear();
                if (this.mHasQueue) {
                    while ((r = (Request)this.mQueue.poll()) != null) {
                        r.terminate();
                    }
                }
            }
        }
        this.mProgressMonitorEnabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate(SessionID sessionID) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Attempting to terminate requests joined to session: " + sessionID);
        }
        HashSet hashSet = this.mProcessingPool;
        synchronized (hashSet) {
            Queue queue = this.mQueue;
            synchronized (queue) {
                this.terminateActiveRequests(sessionID);
                this.terminateQueuedRequests(sessionID);
            }
        }
    }

    private void terminateActiveRequests(SessionID sessionID) {
        Request request;
        ArrayList<Request> requestsToTerminate = new ArrayList<Request>();
        Iterator i = this.mProcessingPool.iterator();
        while (i.hasNext()) {
            request = (Request)i.next();
            if (!sessionID.equals(request.getSession().getID())) continue;
            requestsToTerminate.add(request);
        }
        i = requestsToTerminate.iterator();
        while (i.hasNext()) {
            request = (Request)i.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Terminating queued request: " + request);
            }
            request.terminate();
        }
    }

    private void terminateQueuedRequests(SessionID sessionID) {
        Request request;
        ArrayList<Request> requestsToTerminate = new ArrayList<Request>();
        Iterator i = this.mQueue.iterator();
        while (i.hasNext()) {
            request = (Request)i.next();
            if (!sessionID.equals(request.getSession().getID())) continue;
            requestsToTerminate.add(request);
        }
        i = requestsToTerminate.iterator();
        while (i.hasNext()) {
            request = (Request)i.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Terminating queued request: " + request);
            }
            request.terminate();
            this.releaseSession(request);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Removing request from queue.");
            }
            this.mQueue.remove(request);
        }
    }

    private final void logStartOfRequest(Document request) {
        if (LOG.isDebugEnabled()) {
            String performDocument = XMLUtilities.xmlDOMToString(request);
            LOG.debug("Engine received the following request:\n\n" + performDocument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int latentLoad() {
        Queue queue = this.mQueue;
        synchronized (queue) {
            return this.mQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int activeLoad() {
        HashSet hashSet = this.mProcessingPool;
        synchronized (hashSet) {
            return this.mProcessingPool.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProcessing(Request request) {
        HashSet hashSet = this.mProcessingPool;
        synchronized (hashSet) {
            return this.mProcessingPool.contains(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQueueing(Request request) {
        if (!this.mHasQueue) {
            return false;
        }
        Queue queue = this.mQueue;
        synchronized (queue) {
            Iterator i = this.mQueue.iterator();
            while (i.hasNext()) {
                if (request != (Request)i.next()) continue;
                return true;
            }
        }
        return false;
    }

    private void joinSession(Request request) throws RequestSpecificationException, RequestExecutionException {
        try {
            this.mConfiguration.getSessionCoordinator().join(request);
        }
        catch (SessionJoinDeniedException e) {
            throw new RequestSpecificationException(e);
        }
        catch (SessionJoinException e) {
            throw new RequestExecutionException(e);
        }
        catch (SessionNotFoundException e) {
            throw new RequestSpecificationException(e);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info(MessageID.MSG_REQUEST_JOINED_SESSION, new Object[]{request.getSession().getID()});
        }
        StatusToStatusObserver statusObserver = new StatusToStatusObserver(request.getSession().getRequestStatus());
        request.getStatus().addObserver(statusObserver);
    }

    private void releaseSession(Request request) {
        try {
            this.mConfiguration.getSessionCoordinator().release(request);
        }
        catch (SessionReleaseException e) {
            LOG.error(e);
        }
        catch (SessionNotFoundException e) {
            LOG.error(e);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info(MessageID.MSG_SESSION_RELEASED_REQUEST, new Object[]{request.getSession().getID()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean processingPoolFull() {
        HashSet hashSet = this.mProcessingPool;
        synchronized (hashSet) {
            return this.mConfiguration.getMaxRequests() == this.mProcessingPool.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean process(Request request) {
        boolean success = true;
        if (this.processingPoolFull() || request == null) {
            return false;
        }
        if (!request.getStatus().isInitialising()) {
            return false;
        }
        HashSet hashSet = this.mProcessingPool;
        synchronized (hashSet) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Moving request into processing pool: " + request);
            }
            this.mProcessingPool.add(request);
            request.getStatus().addObserver(this.mProgressMonitor);
            try {
                request.process();
            }
            catch (IllegalStateException ex) {
                LOG.error(ex);
                success = false;
                this.mProcessingPool.remove(request);
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fillUpPool() {
        if (!this.mHasQueue) {
            return;
        }
        HashSet hashSet = this.mProcessingPool;
        synchronized (hashSet) {
            Queue queue = this.mQueue;
            synchronized (queue) {
                while (this.mQueue.size() > 0 && !this.processingPoolFull()) {
                    Request currRequest = (Request)this.mQueue.poll();
                    this.process(currRequest);
                }
            }
        }
    }
}

