/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.engine;

import java.util.Observable;
import java.util.Observer;
import uk.org.ogsadai.engine.ProcessingStatus;

public class ProcessingStatusObserver
implements Observer {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private boolean mWaiting = true;
    private boolean mInitialising = false;
    private boolean mProcessing = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Observable status, Object owner) {
        ProcessingStatusObserver processingStatusObserver;
        if (((ProcessingStatus)status).isStopped()) {
            processingStatusObserver = this;
            synchronized (processingStatusObserver) {
                this.mWaiting = false;
                this.notify();
            }
        }
        if (((ProcessingStatus)status).isInitialising()) {
            processingStatusObserver = this;
            synchronized (processingStatusObserver) {
                this.mInitialising = true;
                this.notify();
            }
        }
        if (((ProcessingStatus)status).isProcessing()) {
            processingStatusObserver = this;
            synchronized (processingStatusObserver) {
                this.mProcessing = true;
                this.notify();
            }
        }
    }

    public void reset() {
        this.mWaiting = true;
        this.mInitialising = false;
        this.mProcessing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompletion() {
        ProcessingStatusObserver processingStatusObserver = this;
        synchronized (processingStatusObserver) {
            while (this.mWaiting) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    this.mWaiting = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForInitialisation() {
        ProcessingStatusObserver processingStatusObserver = this;
        synchronized (processingStatusObserver) {
            while (!this.mInitialising) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    this.mInitialising = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForProcessing() {
        ProcessingStatusObserver processingStatusObserver = this;
        synchronized (processingStatusObserver) {
            while (!this.mProcessing) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    this.mProcessing = true;
                }
            }
        }
    }
}

