/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.engine;

import java.util.Observable;
import uk.org.ogsadai.engine.ProcessingState;

public class ProcessingStatus
extends Observable {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) The University of Edinburgh 2002 - 2005.";
    private ProcessingState mState;
    private Object mOwner;

    public ProcessingStatus(Object owner, ProcessingState initialState) throws IllegalArgumentException {
        if (initialState == null) {
            throw new IllegalArgumentException("initialState must not be null");
        }
        if (owner == null) {
            throw new IllegalArgumentException("owner must not be null");
        }
        this.mState = initialState;
        this.mOwner = owner;
    }

    public ProcessingStatus(Object owner) throws IllegalArgumentException {
        this(owner, ProcessingState.UNSTARTED);
    }

    private void setState(ProcessingState nextState) {
        if (this.mState == nextState) {
            return;
        }
        this.mState = nextState;
        this.setChanged();
        this.notifyObservers(this.mOwner);
    }

    public synchronized boolean isStopped() {
        return this.mState == ProcessingState.COMPLETED || this.mState == ProcessingState.TERMINATED || this.mState == ProcessingState.ERROR || this.mState == ProcessingState.TIMEDOUT;
    }

    public synchronized boolean isLive() {
        return !this.isStopped();
    }

    public synchronized boolean isActive() {
        return this.mState == ProcessingState.INITIALISING || this.mState == ProcessingState.PROCESSING;
    }

    public final synchronized boolean isCompleted() {
        return this.mState == ProcessingState.COMPLETED;
    }

    public final synchronized boolean isError() {
        return this.mState == ProcessingState.ERROR;
    }

    public final synchronized boolean isTimedOut() {
        return this.mState == ProcessingState.TIMEDOUT;
    }

    public final synchronized boolean isUnstarted() {
        return this.mState == ProcessingState.UNSTARTED;
    }

    public final synchronized boolean isInitialising() {
        return this.mState == ProcessingState.INITIALISING;
    }

    public final synchronized boolean isProcessing() {
        return this.mState == ProcessingState.PROCESSING;
    }

    public final synchronized boolean isTerminated() {
        return this.mState == ProcessingState.TERMINATED;
    }

    public synchronized void setInitialising() throws IllegalStateException {
        if (!this.isUnstarted()) {
            throw new IllegalStateException("ProcessingStatus can only change to INITIALISING from UNSTARTED");
        }
        this.setState(ProcessingState.INITIALISING);
    }

    public void setProcessing() throws IllegalStateException {
        if (!this.isInitialising()) {
            throw new IllegalStateException("ProcessingStatus can only change to PROCESSING from INITIALISING");
        }
        this.setState(ProcessingState.PROCESSING);
    }

    public void setCompleted() throws IllegalStateException {
        if (!this.isProcessing()) {
            throw new IllegalStateException("ProcessingStatus can only change to COMPLETED from PROCESSING");
        }
        this.setState(ProcessingState.COMPLETED);
    }

    public void setError() throws IllegalStateException {
        if (!this.isActive()) {
            throw new IllegalStateException("ProcessingStatus can only change to ERROR from an active state.");
        }
        this.setState(ProcessingState.ERROR);
    }

    public void setTerminated() throws IllegalStateException {
        if (this.isStopped()) {
            throw new IllegalStateException("ProcessingStatus cannot be changed to TERMINATED from a stopped state.");
        }
        this.setState(ProcessingState.TERMINATED);
    }

    public void setTimedOut() {
        if (this.isStopped()) {
            throw new IllegalStateException("ProcessingStatus cannot be changed to TIMEDOUT from a stopped state.");
        }
        this.setState(ProcessingState.TIMEDOUT);
    }

    public String toString() {
        return this.mState.toString();
    }

    public void copyState(ProcessingStatus status) {
        this.setState(status.mState);
    }
}

