/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.engine;

import java.util.Observable;
import uk.org.ogsadai.common.UniqueName;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.msgs.MessageID;
import uk.org.ogsadai.engine.Status;

public class ObservableStatus
extends Observable {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private static DAILogger LOG = DAILogger.getLogger(ObservableStatus.class);
    private Status mStatus;
    private final String mName;

    public ObservableStatus(Status status) {
        this(UniqueName.getInstance().getName(), status);
    }

    public ObservableStatus(String name, Status status) {
        this.mName = name;
        this.mStatus = status;
    }

    public final synchronized Status getStatus() {
        return this.mStatus;
    }

    public final synchronized void setStatus(Status status) {
        this.mStatus = status;
        if (LOG.isInfoEnabled()) {
            LOG.info(MessageID.MSG_STATUS_CHANGED, new Object[]{this.mName, this.mStatus});
        }
        this.setChanged();
        this.notifyObservers(status);
    }
}

