/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.engine;

import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.dataresource.DataResourceAccessor;
import uk.org.ogsadai.engine.ConcurrencySettings;
import uk.org.ogsadai.engine.EngineConfiguration;
import uk.org.ogsadai.sessions.SessionCoordinator;

public final class EngineConfigurationImpl
implements EngineConfiguration {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private static final DAILogger LOG = DAILogger.getLogger(EngineConfigurationImpl.class);
    private final SessionCoordinator mSessionCoordinator;
    private DataResourceAccessor mDataResourceAccessor;
    private final ConcurrencySettings mConcurrencySettings;

    public EngineConfigurationImpl(SessionCoordinator sessionCoordinator, ConcurrencySettings concurrencySettings) {
        if (sessionCoordinator == null) {
            throw new IllegalArgumentException("sessionCoordinator must not be null");
        }
        if (concurrencySettings == null) {
            throw new IllegalArgumentException("concurrencySettings must not be null");
        }
        this.mSessionCoordinator = sessionCoordinator;
        this.mConcurrencySettings = concurrencySettings;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Maximum number of requests: " + this.mConcurrencySettings.getMaxRequests());
            LOG.debug("Maximum queue length: " + this.mConcurrencySettings.getMaxQueueLength());
            LOG.debug("Request processing timeout: " + this.mConcurrencySettings.getRequestProcessingTimeout());
        }
    }

    public final DataResourceAccessor getDataResourceAccessor() {
        return this.mDataResourceAccessor;
    }

    public void setDataResourceAccessor(DataResourceAccessor dataResourceAccessor) {
        if (dataResourceAccessor == null) {
            throw new IllegalArgumentException("dataResourceAccessor must not be null");
        }
        this.mDataResourceAccessor = dataResourceAccessor;
    }

    public int getMaxQueueLength() {
        return this.mConcurrencySettings.getMaxQueueLength();
    }

    public int getMaxRequests() {
        return this.mConcurrencySettings.getMaxRequests();
    }

    public long getRequestProcessingTimeout() {
        return this.mConcurrencySettings.getRequestProcessingTimeout();
    }

    public SessionCoordinator getSessionCoordinator() {
        return this.mSessionCoordinator;
    }
}

