/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.engine;

public class ConcurrencySettings {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006.";
    private static final int MAX_REQUESTS = 1;
    private static final int MAX_QUEUE_LENGTH = 0;
    private static final long REQUEST_PROCESSING_TIMEOUT = 0L;
    private int mMaxRequests;
    private int mMaxQueueLength;
    private long mRequestProcessingTimeout;

    public ConcurrencySettings() {
        this(1, 0, 0L);
    }

    public ConcurrencySettings(int maxRequests, int maxQueueLength, long requestProcessingTimeout) throws IllegalArgumentException {
        if (maxRequests < 1) {
            throw new IllegalArgumentException("maxRequests must be >= 1");
        }
        if (maxQueueLength < 0) {
            throw new IllegalArgumentException("maxQueueLength must be >= 0");
        }
        if (requestProcessingTimeout < 0L) {
            throw new IllegalArgumentException("requestProcessingTimeout must be >= 0");
        }
        this.mMaxRequests = maxRequests;
        this.mMaxQueueLength = maxQueueLength;
        this.mRequestProcessingTimeout = requestProcessingTimeout;
    }

    public int getMaxRequests() {
        return this.mMaxRequests;
    }

    public int getMaxQueueLength() {
        return this.mMaxQueueLength;
    }

    public long getRequestProcessingTimeout() {
        return this.mRequestProcessingTimeout;
    }
}

