/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.dataresource.config;

import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import uk.org.ogsadai.common.properties.Property;
import uk.org.ogsadai.common.properties.PropertyValueException;
import uk.org.ogsadai.common.properties.StaticProperty;
import uk.org.ogsadai.dataresource.DataResourcePropertyNames;
import uk.org.ogsadai.exception.ExternalModuleException;

public class ProductInfo {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) The University of Edinburgh 2002 - 2005.";
    private String mName;
    private String mVendor;
    private String mVersion;
    private Element mProductInfoElt = null;
    private Property mProperty;

    public void configure(Element elt) throws IllegalArgumentException, ExternalModuleException {
        Element versionElt;
        Element vendorElt;
        if (elt == null) {
            throw new IllegalArgumentException("elt must not be null");
        }
        if (!elt.getNodeName().equals("productInfo")) {
            throw new IllegalArgumentException("elt must contain a 'productInfo' root node");
        }
        Element nameElt = (Element)elt.getElementsByTagName("productName").item(0);
        Text text = (Text)nameElt.getFirstChild();
        if (text != null) {
            this.setName(text.getNodeValue());
        }
        if ((text = (Text)(vendorElt = (Element)elt.getElementsByTagName("vendorName").item(0)).getFirstChild()) != null) {
            this.setVendor(text.getNodeValue());
        }
        if ((text = (Text)(versionElt = (Element)elt.getElementsByTagName("productVersion").item(0)).getFirstChild()) != null) {
            this.setVersion(text.getNodeValue());
        }
        this.buildProductInfoDocument();
        this.buildProductInfoProperty();
    }

    private void buildProductInfoDocument() {
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            this.mProductInfoElt = doc.createElementNS(DataResourcePropertyNames.PRODUCT_INFO.getNamespaceURI(), DataResourcePropertyNames.PRODUCT_INFO.getLocalPart());
            doc.appendChild(this.mProductInfoElt);
            Element name = doc.createElementNS(DataResourcePropertyNames.PRODUCT_INFO.getNamespaceURI(), "productName");
            this.mProductInfoElt.appendChild(name);
            name.appendChild(doc.createTextNode(this.mName));
            Element version = doc.createElementNS(DataResourcePropertyNames.PRODUCT_INFO.getNamespaceURI(), "productVersion");
            this.mProductInfoElt.appendChild(version);
            version.appendChild(doc.createTextNode(this.mVersion));
            Element vendor = doc.createElementNS(DataResourcePropertyNames.PRODUCT_INFO.getNamespaceURI(), "vendorName");
            this.mProductInfoElt.appendChild(vendor);
            vendor.appendChild(doc.createTextNode(this.mVendor));
        }
        catch (Exception e) {
            throw new ExternalModuleException(e);
        }
    }

    private void buildProductInfoProperty() {
        this.mProperty = new StaticProperty();
        this.mProperty.setName(DataResourcePropertyNames.PRODUCT_INFO);
        try {
            this.mProperty.setValue(this.mProductInfoElt);
        }
        catch (PropertyValueException propertyValueException) {
            // empty catch block
        }
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
        this.flagAsChanged();
    }

    public String getVendor() {
        return this.mVendor;
    }

    public void setVendor(String vendor) {
        this.mVendor = vendor;
        this.flagAsChanged();
    }

    public String getVersion() {
        return this.mVersion;
    }

    public void setVersion(String version) {
        this.mVersion = version;
        this.flagAsChanged();
    }

    public Property getProperty() {
        if (this.mProductInfoElt == null) {
            this.buildProductInfoDocument();
            try {
                this.mProperty.setValue(this.mProductInfoElt);
            }
            catch (PropertyValueException propertyValueException) {
                // empty catch block
            }
        }
        return this.mProperty;
    }

    private void flagAsChanged() {
        this.mProductInfoElt = null;
    }
}

