/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.dataresource.config;

import java.util.ArrayList;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.common.properties.DynamicProperty;
import uk.org.ogsadai.common.properties.DynamicPropertyCreationException;
import uk.org.ogsadai.common.properties.Property;
import uk.org.ogsadai.common.properties.StaticProperty;

public class MetaData {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) The University of Edinburgh 2002 - 2005.";
    private Property[] mProperties;

    public void configure(Element elt) throws IllegalArgumentException, DynamicPropertyCreationException {
        if (elt == null) {
            throw new IllegalArgumentException("elt must not be null");
        }
        if (!elt.getNodeName().equals("metaData")) {
            throw new IllegalArgumentException("elt must contain a 'metaData' root node");
        }
        NodeList kids = elt.getChildNodes();
        int numKids = kids.getLength();
        Vector<Node> filteredKids = new Vector<Node>();
        for (int i = 0; i < numKids; ++i) {
            Node kid = kids.item(i);
            if (kid.getNodeType() != 1 || kid.getNodeName().equals("productInfo")) continue;
            filteredKids.add(kid);
        }
        numKids = filteredKids.size();
        Element[] metaData = new Element[numKids];
        for (int i = 0; i < numKids; ++i) {
            metaData[i] = (Element)filteredKids.get(i);
        }
        this.buildProperties(metaData);
    }

    public Property[] getProperties() {
        return this.mProperties;
    }

    private void buildProperties(Element[] metaData) throws DynamicPropertyCreationException {
        int i;
        ArrayList<StaticProperty> properties = new ArrayList<StaticProperty>();
        int numElts = metaData.length;
        for (i = 0; i < numElts; ++i) {
            Property property;
            Element elt = metaData[i];
            if (elt.getNodeName().equals("xmlMetaData")) continue;
            QName name = new QName(elt.getNamespaceURI(), elt.getLocalName());
            String callback = elt.getAttribute("callback");
            if (callback == null || callback.trim().equals("")) {
                property = new StaticProperty();
                property.setName(name);
                property.setValue(elt);
                properties.add((StaticProperty)property);
                continue;
            }
            property = DynamicProperty.createDynamicProperty(name, callback);
            properties.add((StaticProperty)property);
        }
        this.mProperties = new Property[properties.size()];
        for (i = 0; i < properties.size(); ++i) {
            this.mProperties[i] = (Property)properties.get(i);
        }
    }
}

