/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.dataresource.config;

import org.w3c.dom.Element;
import org.w3c.dom.Text;
import uk.org.ogsadai.common.msgs.DAILogger;

public class DataServiceInfo {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006";
    public static final String RESPONSE_OK = "Ok";
    public static final String RESPONSE_ERROR = "Error";
    public static final String RESPONSE_TIMEOUT = "Timeout";
    public static final String NOT_AVAILABLE = "N/A";
    private String mDsUrl = null;
    private String mDrId = null;
    private String mDsDescription = null;
    private long mDefaultTimeOut = 0L;
    private long mMaximumTimeOut = 0L;
    private String mLastResponse = "N/A";
    private static DAILogger LOG = DAILogger.getLogger(DataServiceInfo.class);

    public String getDsUrl() {
        return this.mDsUrl;
    }

    public String getDrId() {
        return this.mDrId;
    }

    public String getDsDescription() {
        return this.mDsDescription;
    }

    public long getDefaultTimeOut() {
        return this.mDefaultTimeOut;
    }

    public long getMaximumTimeOut() {
        return this.mMaximumTimeOut;
    }

    public void setDsUrl(String url) {
        this.mDsUrl = url;
    }

    public void setDrId(String id) {
        this.mDrId = id;
    }

    public void setDsDescription(String desc) {
        this.mDsDescription = desc;
    }

    public void setDefaultTimeOut(long timeout) {
        this.mDefaultTimeOut = timeout;
    }

    public void setMaximumTimeOut(long timeout) {
        this.mMaximumTimeOut = timeout;
    }

    public void configure(Element dsElement) throws IllegalArgumentException {
        if (dsElement == null) {
            throw new IllegalArgumentException("dsElement must not be null");
        }
        if (!dsElement.getNodeName().equals("unitDataServiceConfig")) {
            throw new IllegalArgumentException("The element's name should be must 'UnitDataServiceConfig'");
        }
        Element tmpElt = (Element)dsElement.getElementsByTagName("dataServiceURL").item(0);
        Text text = (Text)tmpElt.getFirstChild();
        if (text != null) {
            this.setDsUrl(text.getNodeValue());
        }
        if ((text = (Text)(tmpElt = (Element)dsElement.getElementsByTagName("dataResourceName").item(0)).getFirstChild()) != null) {
            this.setDrId(text.getNodeValue());
        }
        if ((text = (Text)(tmpElt = (Element)dsElement.getElementsByTagName("dataResourceDescription").item(0)).getFirstChild()) != null) {
            this.setDsDescription(text.getNodeValue());
        }
        if ((text = (Text)(tmpElt = (Element)dsElement.getElementsByTagName("defaultTimeOut").item(0)).getFirstChild()) != null) {
            this.setDefaultTimeOut(Long.parseLong(text.getNodeValue()));
        }
        if ((text = (Text)(tmpElt = (Element)dsElement.getElementsByTagName("maximumTimeOut").item(0)).getFirstChild()) != null) {
            this.setMaximumTimeOut(Long.parseLong(text.getNodeValue()));
        }
    }

    public String getLastResponse() {
        return this.mLastResponse;
    }

    public void setLastResponse(String lastResponse) {
        this.mLastResponse = lastResponse;
    }
}

