/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.dataresource;

import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;
import uk.org.ogsadai.common.files.DAIFileContentError;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.properties.DynamicProperty;
import uk.org.ogsadai.common.properties.DynamicPropertyCreationException;
import uk.org.ogsadai.common.properties.Property;
import uk.org.ogsadai.common.rolemap.DatabaseRole;
import uk.org.ogsadai.common.rolemap.RoleMapAuthorizationException;
import uk.org.ogsadai.common.rolemap.RoleMapCannotAuthorizeException;
import uk.org.ogsadai.common.rolemap.RoleMapConfigurationException;
import uk.org.ogsadai.common.rolemap.RoleMapper;
import uk.org.ogsadai.common.rolemap.RoleMapperCreationException;
import uk.org.ogsadai.common.xml.XMLParseException;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.dataresource.DataResourceAccessor;
import uk.org.ogsadai.dataresource.DataResourceAccessorConfigException;
import uk.org.ogsadai.dataresource.DataResourceAccessorMetaDataException;
import uk.org.ogsadai.dataresource.DataResourceAccessorSetupException;
import uk.org.ogsadai.dataresource.DataResourceAuthorizationException;
import uk.org.ogsadai.dataresource.DataResourcePropertyNames;
import uk.org.ogsadai.dataresource.PersistInFiles;
import uk.org.ogsadai.dataresource.XMLDBCloseCollectionException;
import uk.org.ogsadai.dataresource.XMLDBCollectionAccessException;
import uk.org.ogsadai.dataresource.XMLDBCollectionProvider;
import uk.org.ogsadai.dataresource.XMLDBCollectionUseException;
import uk.org.ogsadai.dataresource.XMLDBMetaDataExtractor;
import uk.org.ogsadai.dataresource.XMLDBRegistrationException;
import uk.org.ogsadai.dataresource.XMLDBUnknownCollectionException;
import uk.org.ogsadai.dataresource.XMLDBUnknownSubCollectionException;
import uk.org.ogsadai.dataresource.config.MetaData;
import uk.org.ogsadai.dataresource.config.ProductInfo;
import uk.org.ogsadai.dataresource.config.RoleMapperSpec;
import uk.org.ogsadai.exception.AuthorizationExecutionException;
import uk.org.ogsadai.exception.DAIClassCreateException;
import uk.org.ogsadai.exception.DAIClassMissingInterfaceException;
import uk.org.ogsadai.exception.DAIClassNotFoundException;
import uk.org.ogsadai.exception.DAIException;

public class XMLDBDataResourceAccessor
implements DataResourceAccessor,
PersistInFiles,
XMLDBCollectionProvider {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private static DAILogger LOG = DAILogger.getLogger(XMLDBDataResourceAccessor.class);
    private static final String MAIN_CONFIG_FILE_NAME = "dataResourceConfig.xml";
    private String mResourceName;
    private Property[] mProperties;
    private RoleMapper mRoleMapper;
    private String mDriverClassName;
    private String mCollectionURI;

    public void setResourceName(String resourceName) {
        if (resourceName == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.mResourceName = resourceName;
    }

    public void restoreFromConfig(File directory) throws DataResourceAccessorConfigException, DataResourceAccessorMetaDataException, DataResourceAccessorSetupException, IllegalArgumentException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Configuring XMLDBDataResourceAccessor");
        }
        if (directory == null) {
            throw new IllegalArgumentException("directory must not be null");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("directory " + directory.getAbsolutePath() + " must be a directory");
        }
        Document configDocument = this.getConfigAsDOM(this.mResourceName, directory);
        Property productInfo = this.getProductInfo(configDocument);
        Property[] metaData = this.getMetaData(this.mResourceName, configDocument);
        Property collectionSchema = this.getCollectionSchema(this.mResourceName, configDocument);
        this.mProperties = this.getProperties(productInfo, collectionSchema, metaData);
        try {
            this.mRoleMapper = this.getRoleMapper(configDocument);
        }
        catch (RoleMapperCreationException e) {
            throw new DataResourceAccessorSetupException(this.mResourceName, e);
        }
        catch (RoleMapConfigurationException e) {
            throw new DataResourceAccessorSetupException(this.mResourceName, e);
        }
        try {
            this.mDriverClassName = this.getAndLoadDriverClassName(configDocument);
        }
        catch (DAIException e) {
            throw new DataResourceAccessorSetupException(this.mResourceName, e);
        }
        this.mCollectionURI = this.getCollectionURI(configDocument);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished configuring XMLDBDataResourceAccessor");
        }
    }

    private Document getConfigAsDOM(String name, File dir) throws DataResourceAccessorConfigException {
        Document result;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading data resource accessor configuration file");
        }
        boolean VALIDATE = true;
        File file = new File(dir, MAIN_CONFIG_FILE_NAME);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Directory is: " + dir.getAbsolutePath());
            LOG.debug("File name is: " + file.getAbsolutePath());
        }
        try {
            result = XMLUtilities.xmlFileToDOM(file.getAbsolutePath(), true);
        }
        catch (XMLParseException e) {
            DAIFileContentError error = new DAIFileContentError(file, (Throwable)e);
            throw new DataResourceAccessorConfigException(name, error);
        }
        catch (DAIException e) {
            throw new DataResourceAccessorConfigException(name, e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Read data resource accessor configuration file");
        }
        return result;
    }

    private Property getProductInfo(Document configDoc) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracting product meta data");
        }
        Property productInfoProperty = null;
        Element elt = XMLUtilities.getElement(configDoc, "productInfo");
        if (elt != null) {
            ProductInfo productInfo = new ProductInfo();
            productInfo.configure(elt);
            productInfoProperty = productInfo.getProperty();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracted product meta data");
        }
        return productInfoProperty;
    }

    private Property[] getMetaData(String name, Document configDoc) throws DataResourceAccessorMetaDataException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracting meta data from configuration");
        }
        MetaData metaData = new MetaData();
        Element metaDataElement = XMLUtilities.getElement(configDoc, "metaData");
        try {
            metaData.configure(metaDataElement);
        }
        catch (DynamicPropertyCreationException e) {
            throw new DataResourceAccessorMetaDataException(name, e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracted meta data");
        }
        return metaData.getProperties();
    }

    private Property[] getProperties(Property productInfo, Property collectionSchema, Property[] metaData) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Constructing properties");
        }
        int index = 0;
        int numProperties = metaData.length;
        if (productInfo != null) {
            ++numProperties;
        }
        if (collectionSchema != null) {
            ++numProperties;
        }
        Property[] properties = new Property[numProperties];
        if (productInfo != null) {
            properties[index++] = productInfo;
        }
        if (collectionSchema != null) {
            properties[index++] = collectionSchema;
        }
        for (int i = 0; i < metaData.length; ++i) {
            properties[index++] = metaData[i];
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Constructed properties");
        }
        return properties;
    }

    private Property getCollectionSchema(String name, Document configDoc) throws DataResourceAccessorMetaDataException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracting collectionSchema meta data from configuration");
        }
        String className = XMLUtilities.getAttributeValue(configDoc, "collectionSchema", "callback");
        if (LOG.isDebugEnabled()) {
            LOG.debug("collectionSchema meta data extactor class name is: " + className);
        }
        if (className == null) {
            return null;
        }
        DynamicProperty property = null;
        try {
            property = DynamicProperty.createDynamicProperty(DataResourcePropertyNames.COLLECTION_SCHEMA, className);
        }
        catch (DynamicPropertyCreationException e) {
            throw new DataResourceAccessorMetaDataException(name, e);
        }
        if (property.getCallback() instanceof XMLDBMetaDataExtractor) {
            ((XMLDBMetaDataExtractor)((Object)property.getCallback())).setCollectionProvider(this);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracted collectionSchema meta data");
        }
        return property;
    }

    private RoleMapper getRoleMapper(Document configDoc) throws RoleMapperCreationException, RoleMapConfigurationException {
        RoleMapper roleMapper;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating and initialising role mapper");
        }
        NodeList elts = configDoc.getDocumentElement().getElementsByTagName("roleMap");
        RoleMapperSpec spec = new RoleMapperSpec();
        spec.configure((Element)elts.item(0));
        String className = spec.getImplementation();
        try {
            Class<?> roleMapperClass = Class.forName(className);
            roleMapper = (RoleMapper)roleMapperClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            DAIClassNotFoundException ex = new DAIClassNotFoundException(className);
            throw new RoleMapperCreationException(ex);
        }
        catch (InstantiationException e) {
            DAIClassCreateException ex = new DAIClassCreateException(className, e);
            throw new RoleMapperCreationException(ex);
        }
        catch (IllegalAccessException e) {
            DAIClassCreateException ex = new DAIClassCreateException(className, e);
            throw new RoleMapperCreationException(ex);
        }
        catch (ClassCastException e) {
            DAIClassMissingInterfaceException ex = new DAIClassMissingInterfaceException(className, RoleMapper.class.getName());
            throw new RoleMapperCreationException(ex);
        }
        roleMapper.setConfiguration(spec.getConfiguration());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created and initialised role mapper");
        }
        return roleMapper;
    }

    private String getAndLoadDriverClassName(Document configDoc) throws DAIClassNotFoundException, DAIClassCreateException, DAIClassMissingInterfaceException, XMLDBRegistrationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracting and registering database driver class");
        }
        String className = null;
        try {
            className = XMLUtilities.getAttributeValue(configDoc, "driver", "implementation");
            Class<?> c = Class.forName(className);
            Database db = (Database)c.newInstance();
            DatabaseManager.registerDatabase((Database)db);
        }
        catch (ClassNotFoundException e) {
            throw new DAIClassNotFoundException(className);
        }
        catch (IllegalAccessException e) {
            throw new DAIClassCreateException(className);
        }
        catch (InstantiationException e) {
            throw new DAIClassCreateException(className);
        }
        catch (ClassCastException e) {
            throw new DAIClassMissingInterfaceException(className, Database.class.getName());
        }
        catch (XMLDBException e) {
            throw new XMLDBRegistrationException(className, e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracted and registered database driver class: " + className);
        }
        return className;
    }

    private String getCollectionURI(Document configDoc) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracting database URI");
        }
        String collectionURI = XMLUtilities.getElementValue(configDoc, "uri");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracted database URI: " + collectionURI);
        }
        return collectionURI;
    }

    public Property[] getProperties() {
        return this.mProperties;
    }

    public String getBaseCollectionURI() {
        return this.mCollectionURI;
    }

    public Collection getXMLDBCollection(String userCredentials) throws DataResourceAuthorizationException, XMLDBCollectionUseException, AuthorizationExecutionException {
        Collection result = null;
        try {
            result = this.getXMLDBCollection(null, userCredentials);
        }
        catch (XMLDBUnknownSubCollectionException xMLDBUnknownSubCollectionException) {
            // empty catch block
        }
        return result;
    }

    public Collection getXMLDBCollection(String subCollection, String userCredentials) throws DataResourceAuthorizationException, XMLDBUnknownSubCollectionException, XMLDBCollectionUseException, AuthorizationExecutionException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting collection from XMLDBDataResourceAccessor");
        }
        String collectionURI = this.mCollectionURI;
        if (subCollection != null && subCollection.length() != 0) {
            collectionURI = collectionURI + "/" + subCollection;
        }
        DatabaseRole role = null;
        try {
            role = (DatabaseRole)this.mRoleMapper.map(userCredentials, this.mCollectionURI);
        }
        catch (RoleMapAuthorizationException e) {
            throw new DataResourceAuthorizationException(userCredentials, e);
        }
        catch (RoleMapCannotAuthorizeException e) {
            throw new AuthorizationExecutionException(e);
        }
        Collection collection = this.getCollection(collectionURI, role.getUserId(), role.getPassword());
        if (collection == null) {
            if (subCollection == null || subCollection.length() == 0) {
                XMLDBUnknownCollectionException ex = new XMLDBUnknownCollectionException(collectionURI, role.getUserId());
                throw new XMLDBCollectionUseException(this.mCollectionURI, ex);
            }
            throw new XMLDBUnknownSubCollectionException(subCollection);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Have collection from XMLDBDataResourceAccessor");
        }
        return collection;
    }

    public void releaseXMLDBCollection(Collection collection) throws XMLDBCollectionUseException {
        try {
            if (collection != null && collection.isOpen()) {
                collection.close();
            }
        }
        catch (XMLDBException e) {
            XMLDBCloseCollectionException ex = new XMLDBCloseCollectionException(e);
            throw new XMLDBCollectionUseException(this.mCollectionURI, ex);
        }
    }

    protected Collection getCollection(String collectionURI, String user, String password) throws XMLDBCollectionUseException {
        Collection collection = null;
        try {
            collection = DatabaseManager.getCollection((String)collectionURI, (String)user, (String)password);
        }
        catch (XMLDBException e) {
            XMLDBCollectionAccessException ex = new XMLDBCollectionAccessException(collectionURI, user, e);
            throw new XMLDBCollectionUseException(collectionURI, ex);
        }
        return collection;
    }
}

