/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.dataresource;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import uk.org.ogsadai.common.SecurityContext;
import uk.org.ogsadai.common.properties.PropertyCallback;
import uk.org.ogsadai.dataresource.DataResourcePropertyNames;
import uk.org.ogsadai.dataresource.SQLMultipleDataResourceAccessor;
import uk.org.ogsadai.dataresource.config.DataServiceInfo;
import uk.org.ogsadai.exception.ExternalModuleException;

public class StatusOfDataServices
implements PropertyCallback {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006";
    public static final String DATA_SERVICE = "aDataService";
    public static final String DESCRIPTION = "serviceDescription";
    public static final String RESPONSE = "lastResponse";
    SQLMultipleDataResourceAccessor mDataResource;

    public StatusOfDataServices(SQLMultipleDataResourceAccessor dataRes) {
        this.mDataResource = dataRes;
    }

    public Object getValue(QName name) {
        if (name == null || !name.equals(DataResourcePropertyNames.STATUS_OF_DATA_SERVICES)) {
            return null;
        }
        return this.getStatus();
    }

    public void setValue(QName name, Object value) {
        throw new UnsupportedOperationException("setValue method is not supported by StatusOfDataServices");
    }

    public void setSecurityContext(SecurityContext sec) {
    }

    private Element getStatus() {
        DataServiceInfo[] services = this.mDataResource.getMultipleDS();
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new ExternalModuleException(e.getCause());
        }
        catch (FactoryConfigurationError e) {
            throw new ExternalModuleException(e.getCause());
        }
        String namespace = DataResourcePropertyNames.STATUS_OF_DATA_SERVICES.getNamespaceURI();
        String localpart = DataResourcePropertyNames.STATUS_OF_DATA_SERVICES.getLocalPart();
        Element result = doc.createElementNS(namespace, localpart);
        doc.appendChild(result);
        for (int i = 0; i < services.length; ++i) {
            Element service = doc.createElementNS(namespace, DATA_SERVICE);
            result.appendChild(service);
            Element description = doc.createElementNS(namespace, DESCRIPTION);
            service.appendChild(description);
            description.appendChild(doc.createTextNode(services[i].getDsDescription()));
            Element status = doc.createElementNS(namespace, RESPONSE);
            service.appendChild(status);
            status.appendChild(doc.createTextNode(services[i].getLastResponse()));
        }
        return result;
    }
}

