/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.dataresource;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.Service;
import org.xmldb.api.base.XMLDBException;
import uk.org.ogsadai.common.SecurityContext;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.dataresource.DataResourcePropertyNames;
import uk.org.ogsadai.dataresource.MetaDataAuthorizationException;
import uk.org.ogsadai.dataresource.MetaDataExtractionException;
import uk.org.ogsadai.dataresource.MetaDataExtractor;
import uk.org.ogsadai.dataresource.XMLDBCollectionProvider;
import uk.org.ogsadai.dataresource.XMLDBCollectionUseException;
import uk.org.ogsadai.dataresource.XMLDBMetaDataExtractor;
import uk.org.ogsadai.exception.DAIAuthorizationException;
import uk.org.ogsadai.exception.ExternalModuleException;

public class SimpleXMLDBMetaDataExtractor
extends MetaDataExtractor
implements XMLDBMetaDataExtractor {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006";
    private static DAILogger LOG = DAILogger.getLogger(SimpleXMLDBMetaDataExtractor.class);
    public static final String COLLECTION = "collection";
    public static final String COLLECTION_ATTR_NAME = "name";
    public static final String COLLECTIONS = "subCollections";
    public static final String SERVICES = "services";
    public static final String SERVICE = "service";
    public static final String SERVICE_ATTR_NAME = "name";
    public static final String SERVICE_ATTR_VERSION = "version";
    public static final String RESOURCES = "resources";
    public static final String RESOURCE = "resource";
    public static final String RESOURCE_ATTR_ID = "id";
    public static final String RESOURCE_ATTR_TYPE = "type";
    private XMLDBCollectionProvider mCollectionProvider;

    public void setCollectionProvider(XMLDBCollectionProvider collectionProvider) {
        this.mCollectionProvider = collectionProvider;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object getMetaData(SecurityContext securityContext, QName name) throws MetaDataAuthorizationException, MetaDataExtractionException {
        Collection collection = null;
        if (name == null) return null;
        if (!name.equals(DataResourcePropertyNames.COLLECTION_SCHEMA)) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracting collection schema");
        }
        Object metaData = null;
        String userCredentials = securityContext.getDN();
        try {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Getting collection for meta data extraction");
                }
                collection = this.mCollectionProvider.getXMLDBCollection(userCredentials);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Got collection");
                }
                metaData = this.getCollectionSchema(this.mCollectionProvider.getBaseCollectionURI(), collection, name);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Extracted collection schema");
                }
            }
            catch (DAIAuthorizationException e) {
                throw new MetaDataAuthorizationException(name, userCredentials, e);
            }
            catch (Exception e) {
                throw new MetaDataExtractionException(name, e);
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            try {
                this.mCollectionProvider.releaseXMLDBCollection(collection);
                throw throwable;
            }
            catch (Exception e) {
                throw new MetaDataExtractionException(name, e);
            }
        }
        try {}
        catch (Exception e) {
            throw new MetaDataExtractionException(name, e);
        }
        this.mCollectionProvider.releaseXMLDBCollection(collection);
        return metaData;
    }

    private Object getCollectionSchema(String collectionURI, Collection collection, QName name) throws XMLDBCollectionUseException, ExternalModuleException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracting collection schema");
        }
        Document schema = null;
        try {
            schema = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new ExternalModuleException(e);
        }
        Element root = schema.createElementNS(DataResourcePropertyNames.COLLECTION_SCHEMA.getNamespaceURI(), DataResourcePropertyNames.COLLECTION_SCHEMA.getLocalPart());
        schema.appendChild(root);
        Element logicalSchema = schema.createElementNS("http://ogsadai.org.uk/namespaces/2005/10/properties", "logicalSchema");
        root.appendChild(logicalSchema);
        try {
            this.addCollections(collection, logicalSchema, schema);
        }
        catch (XMLDBException e) {
            throw new XMLDBCollectionUseException(collectionURI, e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracted collection schema");
        }
        return schema.getDocumentElement();
    }

    private void addServices(Collection collection, Element collectionElt, Document schema) throws XMLDBException {
        int numServices;
        Service[] services;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracting services information for: " + collection.getName());
        }
        if ((services = collection.getServices()) != null && (numServices = services.length) > 0) {
            Element servicesElt = schema.createElementNS("http://ogsadai.org.uk/namespaces/2005/10/properties", SERVICES);
            collectionElt.appendChild(servicesElt);
            for (int i = 0; i < numServices; ++i) {
                Service service = services[i];
                Element serviceElt = schema.createElementNS("http://ogsadai.org.uk/namespaces/2005/10/properties", SERVICE);
                servicesElt.appendChild(serviceElt);
                serviceElt.setAttributeNS("http://ogsadai.org.uk/namespaces/2005/10/properties", "name", service.getName());
                serviceElt.setAttributeNS("http://ogsadai.org.uk/namespaces/2005/10/properties", SERVICE_ATTR_VERSION, service.getVersion());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracted services information for: " + collection.getName());
        }
    }

    private void addResources(Collection collection, Element collectionElt, Document schema) throws XMLDBException {
        int numResources;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracting resources information for: " + collection.getName());
        }
        if ((numResources = collection.getResourceCount()) != 0) {
            Element resourcesElt = schema.createElementNS("http://ogsadai.org.uk/namespaces/2005/10/properties", RESOURCES);
            collectionElt.appendChild(resourcesElt);
            String[] resourceNames = collection.listResources();
            for (int i = 0; i < numResources; ++i) {
                Resource resource = collection.getResource(resourceNames[i]);
                Element resourceElt = schema.createElementNS("http://ogsadai.org.uk/namespaces/2005/10/properties", RESOURCE);
                resourcesElt.appendChild(resourceElt);
                resourceElt.setAttributeNS("http://ogsadai.org.uk/namespaces/2005/10/properties", RESOURCE_ATTR_ID, resource.getId());
                resourceElt.setAttributeNS("http://ogsadai.org.uk/namespaces/2005/10/properties", RESOURCE_ATTR_TYPE, resource.getResourceType());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracted resources information for: " + collection.getName());
        }
    }

    private void addCollections(Collection collection, Element elt, Document schema) throws XMLDBException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracting collections information for: " + collection.getName());
        }
        Element collectionElt = schema.createElementNS("http://ogsadai.org.uk/namespaces/2005/10/properties", COLLECTION);
        elt.appendChild(collectionElt);
        collectionElt.setAttributeNS("http://ogsadai.org.uk/namespaces/2005/10/properties", "name", collection.getName());
        this.addResources(collection, collectionElt, schema);
        this.addServices(collection, collectionElt, schema);
        int numCollections = collection.getChildCollectionCount();
        if (numCollections != 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Extracting Child Collection Information for: " + collection.getName());
            }
            Element collectionsElt = schema.createElementNS("http://ogsadai.org.uk/namespaces/2005/10/properties", COLLECTIONS);
            collectionElt.appendChild(collectionsElt);
            String[] collectionNames = collection.listChildCollections();
            for (int i = 0; i < numCollections; ++i) {
                this.addCollections(collection.getChildCollection(collectionNames[i]), collectionsElt, schema);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracted collections information for: " + collection.getName());
        }
    }
}

