/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.dataresource;

import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.common.files.DAIFileContentError;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.properties.DynamicProperty;
import uk.org.ogsadai.common.properties.Property;
import uk.org.ogsadai.common.xml.XMLParseException;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.dataresource.DataResourceAccessor;
import uk.org.ogsadai.dataresource.DataResourceAccessorConfigException;
import uk.org.ogsadai.dataresource.DataResourceAccessorMetaDataException;
import uk.org.ogsadai.dataresource.DataResourceAccessorSetupException;
import uk.org.ogsadai.dataresource.DataResourcePropertyNames;
import uk.org.ogsadai.dataresource.PersistInFiles;
import uk.org.ogsadai.dataresource.StatusOfDataServices;
import uk.org.ogsadai.dataresource.config.DataServiceInfo;
import uk.org.ogsadai.exception.DAIException;

public class SQLMultipleDataResourceAccessor
implements DataResourceAccessor,
PersistInFiles {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2006";
    private static DAILogger LOG = DAILogger.getLogger(SQLMultipleDataResourceAccessor.class);
    private static final String MAIN_CONFIG_FILE_NAME = "dataResourceConfig.xml";
    private static final String DATA_SERVICE_CONFIG_ELEMENT = "unitDataServiceConfig";
    private String mDataResourceName;
    private Property[] mProperties;
    private DataServiceInfo[] mMultipleDS;
    private StatusOfDataServices mStatusCallback;

    public void setResourceName(String resourceName) {
        if (resourceName == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.mDataResourceName = resourceName;
    }

    public void restoreFromConfig(File directory) throws DataResourceAccessorConfigException, DataResourceAccessorMetaDataException, DataResourceAccessorSetupException, IllegalArgumentException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Configuring JDBCDataResource");
        }
        if (this.mDataResourceName == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (directory == null) {
            throw new IllegalArgumentException("directory must not be null");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("directory " + directory.getAbsolutePath() + " must be a directory");
        }
        LOG.debug("Configuring SQLMultipleDataResource");
        Document configDocument = this.getConfigAsDOM(this.mDataResourceName, directory);
        NodeList dataServices = configDocument.getElementsByTagName(DATA_SERVICE_CONFIG_ELEMENT);
        int dsNum = dataServices.getLength();
        this.mMultipleDS = new DataServiceInfo[dsNum];
        for (int i = 0; i < dsNum; ++i) {
            this.mMultipleDS[i] = new DataServiceInfo();
            this.mMultipleDS[i].configure((Element)dataServices.item(i));
        }
        this.mProperties = this.constructProperties();
        LOG.debug("Finished configuring SQLMultipleDataResource");
    }

    public Property[] getProperties() {
        return this.mProperties;
    }

    public void onBeginSession() {
    }

    public void onEndSession() {
    }

    public void onBeginRequest() {
    }

    public void onEndRequest() {
    }

    public void onContainerShutdown() {
    }

    public DataServiceInfo[] getMultipleDS() {
        return this.mMultipleDS;
    }

    private Document getConfigAsDOM(String name, File configDirectory) throws DataResourceAccessorConfigException {
        Document result;
        boolean VALIDATE = true;
        File configFile = null;
        LOG.debug("Getting config file as a DOM");
        configFile = new File(configDirectory, MAIN_CONFIG_FILE_NAME);
        LOG.debug("Config dir is: " + configDirectory.getAbsolutePath());
        LOG.debug("Filename is: " + configFile.getAbsolutePath());
        try {
            result = XMLUtilities.xmlFileToDOM(configFile.getAbsolutePath(), true);
            LOG.debug("Have config file as a DOM");
        }
        catch (XMLParseException e) {
            DAIFileContentError error = new DAIFileContentError(configFile, (Throwable)e);
            throw new DataResourceAccessorConfigException(name, error);
        }
        catch (DAIException e) {
            throw new DataResourceAccessorConfigException(name, e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Read data resource accessor configuration file");
        }
        return result;
    }

    private Property[] constructProperties() {
        LOG.debug("Constructing properties");
        Property[] properties = new Property[1];
        DynamicProperty status = new DynamicProperty();
        status.setName(DataResourcePropertyNames.STATUS_OF_DATA_SERVICES);
        this.mStatusCallback = new StatusOfDataServices(this);
        status.setCallback(this.mStatusCallback);
        properties[0] = status;
        LOG.debug("Returning properties");
        return properties;
    }
}

