/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.dataresource;

import javax.xml.namespace.QName;
import uk.org.ogsadai.common.SecurityContext;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.properties.PropertyCallback;
import uk.org.ogsadai.common.properties.PropertyImmutableException;
import uk.org.ogsadai.common.properties.PropertyValueException;
import uk.org.ogsadai.dataresource.MetaDataAuthorizationException;
import uk.org.ogsadai.dataresource.MetaDataExtractionException;

public abstract class MetaDataExtractor
implements PropertyCallback {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005";
    private static DAILogger LOG = DAILogger.getLogger(MetaDataExtractor.class);
    protected SecurityContext mSecurityContext;

    public void setSecurityContext(SecurityContext sc) {
        this.mSecurityContext = sc;
    }

    public void setValue(QName name, Object value) {
        throw new PropertyImmutableException(name);
    }

    public Object getValue(QName name) throws PropertyValueException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracting meta data for property " + name.toString());
        }
        try {
            Object metadata = this.getMetaData(this.mSecurityContext, name);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Extracted meta data for property " + name.toString());
            }
            return metadata;
        }
        catch (Exception e) {
            throw new PropertyValueException(name, (Throwable)e);
        }
    }

    protected abstract Object getMetaData(SecurityContext var1, QName var2) throws MetaDataAuthorizationException, MetaDataExtractionException;
}

