/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.dataresource;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.common.files.DAIFileContentError;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.properties.DynamicPropertyCreationException;
import uk.org.ogsadai.common.properties.Property;
import uk.org.ogsadai.common.rolemap.DatabaseRole;
import uk.org.ogsadai.common.rolemap.RoleMapAuthorizationException;
import uk.org.ogsadai.common.rolemap.RoleMapCannotAuthorizeException;
import uk.org.ogsadai.common.rolemap.RoleMapConfigurationException;
import uk.org.ogsadai.common.rolemap.RoleMapper;
import uk.org.ogsadai.common.rolemap.RoleMapperCreationException;
import uk.org.ogsadai.common.xml.XMLParseException;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.dataresource.DataResourceAccessor;
import uk.org.ogsadai.dataresource.DataResourceAccessorConfigException;
import uk.org.ogsadai.dataresource.DataResourceAccessorMetaDataException;
import uk.org.ogsadai.dataresource.DataResourceAccessorSetupException;
import uk.org.ogsadai.dataresource.DataResourceAuthorizationException;
import uk.org.ogsadai.dataresource.JDBCCloseConnectionException;
import uk.org.ogsadai.dataresource.JDBCConnectionAccessException;
import uk.org.ogsadai.dataresource.JDBCConnectionProvider;
import uk.org.ogsadai.dataresource.JDBCConnectionUseException;
import uk.org.ogsadai.dataresource.PersistInFiles;
import uk.org.ogsadai.dataresource.config.MetaData;
import uk.org.ogsadai.dataresource.config.ProductInfo;
import uk.org.ogsadai.dataresource.config.RoleMapperSpec;
import uk.org.ogsadai.exception.AuthorizationExecutionException;
import uk.org.ogsadai.exception.DAIClassCreateException;
import uk.org.ogsadai.exception.DAIClassMissingInterfaceException;
import uk.org.ogsadai.exception.DAIClassNotFoundException;
import uk.org.ogsadai.exception.DAIException;

public class JDBCDataResourceAccessor
implements DataResourceAccessor,
PersistInFiles,
JDBCConnectionProvider {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private static DAILogger LOG = DAILogger.getLogger(JDBCDataResourceAccessor.class);
    private static final String MAIN_CONFIG_FILE_NAME = "dataResourceConfig.xml";
    private String mResourceName;
    private Property[] mProperties;
    private RoleMapper mRoleMapper;
    private String mDriverClassName;
    private String mConnectionURI;

    public void setResourceName(String resourceName) {
        if (resourceName == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.mResourceName = resourceName;
    }

    public void restoreFromConfig(File directory) throws DataResourceAccessorConfigException, DataResourceAccessorMetaDataException, DataResourceAccessorSetupException, IllegalArgumentException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Configuring JDBCDataResourceAccessor");
        }
        if (directory == null) {
            throw new IllegalArgumentException("directory must not be null");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("directory " + directory.getAbsolutePath() + " must be a directory");
        }
        Document configDocument = this.getConfigAsDOM(this.mResourceName, directory);
        Property productInfo = this.getProductInfo(configDocument);
        Property[] metaData = this.getMetaData(this.mResourceName, configDocument);
        this.mProperties = this.getProperties(productInfo, metaData);
        try {
            this.mRoleMapper = this.getRoleMapper(configDocument);
        }
        catch (RoleMapperCreationException e) {
            throw new DataResourceAccessorSetupException(this.mResourceName, e);
        }
        catch (RoleMapConfigurationException e) {
            throw new DataResourceAccessorSetupException(this.mResourceName, e);
        }
        try {
            this.mDriverClassName = this.getAndLoadDriverClassName(configDocument);
        }
        catch (DAIClassNotFoundException e) {
            throw new DataResourceAccessorSetupException(this.mResourceName, e);
        }
        this.mConnectionURI = this.getConnectionURI(configDocument);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished configuring JDBCDataResourceAccessor");
        }
    }

    public void readConfig(String name, File directory) throws DataResourceAccessorConfigException, DataResourceAccessorMetaDataException, DataResourceAccessorSetupException, IllegalArgumentException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Configuring JDBCDataResourceAccessor");
        }
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (directory == null) {
            throw new IllegalArgumentException("directory must not be null");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("directory " + directory.getAbsolutePath() + " must be a directory");
        }
        Document configDocument = this.getConfigAsDOM(name, directory);
        Property productInfo = this.getProductInfo(configDocument);
        Property[] metaData = this.getMetaData(name, configDocument);
        this.mProperties = this.getProperties(productInfo, metaData);
        try {
            this.mRoleMapper = this.getRoleMapper(configDocument);
        }
        catch (RoleMapperCreationException e) {
            throw new DataResourceAccessorSetupException(name, e);
        }
        catch (RoleMapConfigurationException e) {
            throw new DataResourceAccessorSetupException(name, e);
        }
        try {
            this.mDriverClassName = this.getAndLoadDriverClassName(configDocument);
        }
        catch (DAIClassNotFoundException e) {
            throw new DataResourceAccessorSetupException(name, e);
        }
        this.mConnectionURI = this.getConnectionURI(configDocument);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished configuring JDBCDataResourceAccessor");
        }
    }

    private Document getConfigAsDOM(String name, File dir) throws DataResourceAccessorConfigException {
        Document result;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading data resource accessor configuration file");
        }
        boolean VALIDATE = true;
        File file = new File(dir, MAIN_CONFIG_FILE_NAME);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Directory is: " + dir.getAbsolutePath());
            LOG.debug("File name is: " + file.getAbsolutePath());
        }
        try {
            result = XMLUtilities.xmlFileToDOM(file.getAbsolutePath(), true);
        }
        catch (XMLParseException e) {
            DAIFileContentError error = new DAIFileContentError(file, (Throwable)e);
            throw new DataResourceAccessorConfigException(name, error);
        }
        catch (DAIException e) {
            throw new DataResourceAccessorConfigException(name, e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Read data resource accessor configuration file");
        }
        return result;
    }

    private Property getProductInfo(Document configDoc) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracting product meta data");
        }
        Property productInfoProperty = null;
        Element elt = XMLUtilities.getElement(configDoc, "productInfo");
        if (elt != null) {
            ProductInfo productInfo = new ProductInfo();
            productInfo.configure(elt);
            productInfoProperty = productInfo.getProperty();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracted product meta data");
        }
        return productInfoProperty;
    }

    private Property[] getMetaData(String name, Document configDoc) throws DataResourceAccessorMetaDataException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracting meta data from configuration");
        }
        MetaData metaData = new MetaData();
        Element metaDataElement = XMLUtilities.getElement(configDoc, "metaData");
        try {
            metaData.configure(metaDataElement);
        }
        catch (DynamicPropertyCreationException e) {
            throw new DataResourceAccessorMetaDataException(name, e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracted meta data");
        }
        return metaData.getProperties();
    }

    private Property[] getProperties(Property productInfo, Property[] metaData) {
        Property[] properties;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Constructing properties");
        }
        int index = 0;
        if (productInfo != null) {
            properties = new Property[1 + metaData.length];
            properties[index++] = productInfo;
        } else {
            properties = new Property[metaData.length];
        }
        for (int i = 0; i < metaData.length; ++i) {
            properties[index++] = metaData[i];
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Constructed properties");
        }
        return properties;
    }

    private RoleMapper getRoleMapper(Document configDoc) throws RoleMapperCreationException, RoleMapConfigurationException {
        RoleMapper roleMapper;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating and initialising role mapper");
        }
        NodeList elts = configDoc.getDocumentElement().getElementsByTagName("roleMap");
        RoleMapperSpec spec = new RoleMapperSpec();
        spec.configure((Element)elts.item(0));
        String className = spec.getImplementation();
        try {
            Class<?> roleMapperClass = Class.forName(className);
            roleMapper = (RoleMapper)roleMapperClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            DAIClassNotFoundException ex = new DAIClassNotFoundException(className);
            throw new RoleMapperCreationException(ex);
        }
        catch (InstantiationException e) {
            DAIClassCreateException ex = new DAIClassCreateException(className, e);
            throw new RoleMapperCreationException(ex);
        }
        catch (IllegalAccessException e) {
            DAIClassCreateException ex = new DAIClassCreateException(className, e);
            throw new RoleMapperCreationException(ex);
        }
        catch (ClassCastException e) {
            DAIClassMissingInterfaceException ex = new DAIClassMissingInterfaceException(className, RoleMapper.class.getName());
            throw new RoleMapperCreationException(ex);
        }
        roleMapper.setConfiguration(spec.getConfiguration());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created and initialised role mapper");
        }
        return roleMapper;
    }

    private String getAndLoadDriverClassName(Document configDoc) throws DAIClassNotFoundException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracting database driver class");
        }
        String className = null;
        try {
            className = XMLUtilities.getAttributeValue(configDoc, "driver", "implementation");
            Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new DAIClassNotFoundException(className);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracted database driver class: " + className);
        }
        return className;
    }

    private String getConnectionURI(Document configDoc) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracting database URI");
        }
        String connectionURI = XMLUtilities.getElementValue(configDoc, "uri");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracted database URI: " + connectionURI);
        }
        return connectionURI;
    }

    public Property[] getProperties() {
        return this.mProperties;
    }

    public String getJDBCDriverClassName() {
        return this.mDriverClassName;
    }

    public Connection getJDBCConnection(String userCredentials) throws DataResourceAuthorizationException, JDBCConnectionUseException, AuthorizationExecutionException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting connection from JDBCDataResourceAccessor");
        }
        DatabaseRole role = null;
        try {
            role = (DatabaseRole)this.mRoleMapper.map(userCredentials, this.mConnectionURI);
        }
        catch (RoleMapAuthorizationException e) {
            throw new DataResourceAuthorizationException(userCredentials, e);
        }
        catch (RoleMapCannotAuthorizeException e) {
            throw new AuthorizationExecutionException(e);
        }
        Connection conn = this.getConnection(this.mConnectionURI, role.getUserId(), role.getPassword());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Have connection from JDBCDataResourceAccessor");
        }
        return conn;
    }

    public void releaseJDBCConnection(Connection connection) throws JDBCConnectionUseException {
        try {
            connection.close();
        }
        catch (SQLException e) {
            JDBCCloseConnectionException ex = new JDBCCloseConnectionException(e);
            throw new JDBCConnectionUseException(this.mConnectionURI, ex);
        }
    }

    protected Connection getConnection(String connectionURI, String user, String password) throws JDBCConnectionUseException {
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(connectionURI, user, password);
            return conn;
        }
        catch (SQLException e) {
            JDBCConnectionAccessException ex = new JDBCConnectionAccessException(connectionURI, user, e);
            throw new JDBCConnectionUseException(connectionURI, ex);
        }
    }
}

