/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.dataresource;

import java.io.File;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import uk.org.ogsadai.common.files.DAIDirectoryNotDirectoryException;
import uk.org.ogsadai.common.files.DAIDirectoryNotFoundException;
import uk.org.ogsadai.common.files.DAIFileContentError;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.properties.DynamicPropertyCreationException;
import uk.org.ogsadai.common.properties.Property;
import uk.org.ogsadai.common.xml.XMLParseException;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.dataresource.DataResourceAccessor;
import uk.org.ogsadai.dataresource.DataResourceAccessorConfigException;
import uk.org.ogsadai.dataresource.DataResourceAccessorMetaDataException;
import uk.org.ogsadai.dataresource.DataResourceAccessorSetupException;
import uk.org.ogsadai.dataresource.DataResourceAuthorizationException;
import uk.org.ogsadai.dataresource.FileAccessProvider;
import uk.org.ogsadai.dataresource.FilesResourceUseException;
import uk.org.ogsadai.dataresource.PersistInFiles;
import uk.org.ogsadai.dataresource.config.MetaData;
import uk.org.ogsadai.exception.AuthorizationExecutionException;
import uk.org.ogsadai.exception.DAIException;
import uk.org.ogsadai.exception.DAIFileReadAuthorizationException;
import uk.org.ogsadai.exception.DAIFileWriteAuthorizationException;

public class FilesDataResourceAccessor
implements DataResourceAccessor,
PersistInFiles,
FileAccessProvider {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private static DAILogger LOG = DAILogger.getLogger(FilesDataResourceAccessor.class);
    private static final String MAIN_CONFIG_FILE_NAME = "dataResourceConfig.xml";
    private Property[] mProperties;
    private String mResourceName;
    private File mDirectory;

    public void setResourceName(String resourceName) {
        if (resourceName == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.mResourceName = resourceName;
    }

    public void restoreFromConfig(File directory) throws DataResourceAccessorConfigException, DataResourceAccessorMetaDataException, DataResourceAccessorSetupException, IllegalArgumentException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Configuring FilesDataResourceAccessor");
        }
        if (directory == null) {
            throw new IllegalArgumentException("directory must not be null");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("directory " + directory.getAbsolutePath() + " must be a directory");
        }
        Document configDocument = this.getConfigAsDOM(this.mResourceName, directory);
        this.mProperties = this.getMetaData(this.mResourceName, configDocument);
        String path = this.getRootDirectory(configDocument);
        this.mDirectory = this.getDirectory(this.mResourceName, path);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished configuring FilesDataResourceAccessor");
        }
    }

    private Document getConfigAsDOM(String name, File dir) throws DataResourceAccessorConfigException {
        Document result;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading data resource accessor configuration file");
        }
        File file = new File(dir, MAIN_CONFIG_FILE_NAME);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Directory is: " + dir.getAbsolutePath());
            LOG.debug("File name is: " + file.getAbsolutePath());
        }
        try {
            result = XMLUtilities.xmlFileToDOM(file.getAbsolutePath());
        }
        catch (XMLParseException e) {
            DAIFileContentError error = new DAIFileContentError(file, (Throwable)e);
            throw new DataResourceAccessorConfigException(name, error);
        }
        catch (DAIException e) {
            throw new DataResourceAccessorConfigException(name, e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Read data resource accessor configuration file");
        }
        return result;
    }

    private Property[] getMetaData(String name, Document configDoc) throws DataResourceAccessorMetaDataException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracting meta data from configuration");
        }
        MetaData metaData = new MetaData();
        Element elt = XMLUtilities.getElement(configDoc, "metaData");
        try {
            metaData.configure(elt);
        }
        catch (DynamicPropertyCreationException e) {
            throw new DataResourceAccessorMetaDataException(name, e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracted meta data");
        }
        return metaData.getProperties();
    }

    private String getRootDirectory(Document configDoc) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracting root directory of file data resource");
        }
        String uri = XMLUtilities.getElementValue(configDoc, "rootDirectory");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracted root directory: " + uri);
        }
        return uri;
    }

    private File getDirectory(String name, String path) throws DataResourceAccessorSetupException {
        File directory = new File(path);
        if (!directory.exists()) {
            DAIDirectoryNotFoundException ex = new DAIDirectoryNotFoundException(directory);
            throw new DataResourceAccessorSetupException(name, ex);
        }
        if (!directory.isDirectory()) {
            DAIDirectoryNotDirectoryException ex = new DAIDirectoryNotDirectoryException(directory);
            throw new DataResourceAccessorSetupException(name, ex);
        }
        return directory;
    }

    public Property[] getProperties() {
        return this.mProperties;
    }

    public File getHomeDirectory(String userCredential) throws DataResourceAuthorizationException, FilesResourceUseException, AuthorizationExecutionException {
        return this.mDirectory;
    }

    public boolean canReadFile(String userCredential, File file) throws FilesResourceUseException {
        try {
            String canonicalPath = file.getCanonicalPath();
            String topLevelCanonicalPath = this.mDirectory.getCanonicalPath();
            boolean isSubDir = canonicalPath.startsWith(topLevelCanonicalPath);
            return isSubDir;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void validateReadFile(String userCredential, File file) throws DataResourceAuthorizationException, FilesResourceUseException, AuthorizationExecutionException {
        if (!this.canReadFile(userCredential, file)) {
            DAIFileReadAuthorizationException ex = new DAIFileReadAuthorizationException(userCredential, file);
            throw new DataResourceAuthorizationException(userCredential, ex);
        }
    }

    public boolean canWriteFile(String userCredential, File file) throws FilesResourceUseException {
        return this.canReadFile(userCredential, file);
    }

    public void validateWriteFile(String userCredential, File file) throws DataResourceAuthorizationException, FilesResourceUseException, AuthorizationExecutionException {
        if (!this.canWriteFile(userCredential, file)) {
            DAIFileWriteAuthorizationException ex = new DAIFileWriteAuthorizationException(userCredential, file);
            throw new DataResourceAuthorizationException(userCredential, ex);
        }
    }
}

