/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.dataresource;

import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.common.files.DAIFileContentError;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLParseException;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.dataresource.DataResourceAccessor;
import uk.org.ogsadai.dataresource.DataResourceAccessorConfigException;
import uk.org.ogsadai.dataresource.DataResourceAccessorCreationException;
import uk.org.ogsadai.dataresource.DataResourceAccessorMetaDataException;
import uk.org.ogsadai.dataresource.DataResourceAccessorSetupException;
import uk.org.ogsadai.dataresource.PersistInFiles;
import uk.org.ogsadai.exception.DAIClassCreateException;
import uk.org.ogsadai.exception.DAIClassMissingInterfaceException;
import uk.org.ogsadai.exception.DAIClassNotFoundException;
import uk.org.ogsadai.exception.DAIException;

public class DataResourceAccessorFactory {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005";
    private static DAILogger LOG = DAILogger.getLogger(DataResourceAccessorFactory.class);
    private static DataResourceAccessorFactory mStaticResourceFactory = new DataResourceAccessorFactory();
    private static final String CLASS_CONFIG_FILENAME = "dataResourceClassConfig.xml";

    private DataResourceAccessorFactory() {
    }

    public static DataResourceAccessorFactory getInstance() {
        return mStaticResourceFactory;
    }

    public DataResourceAccessor createDataResourceAccessor(String name, File configDirectory) throws DataResourceAccessorConfigException, DataResourceAccessorCreationException, DataResourceAccessorMetaDataException, DataResourceAccessorSetupException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating data resource accessor for " + name);
        }
        String className = this.getDataResourceClassName(name, configDirectory);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Class name is " + className);
        }
        DataResourceAccessor dataResourceAccessor = this.createDataResourceAccessorInstance(name, className);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created data resource accessor about to configure...");
        }
        dataResourceAccessor.setResourceName(name);
        if (dataResourceAccessor instanceof PersistInFiles) {
            PersistInFiles filePersistedDRA = (PersistInFiles)((Object)dataResourceAccessor);
            filePersistedDRA.restoreFromConfig(configDirectory);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finshed creating data resource accessor for " + name);
        }
        return dataResourceAccessor;
    }

    private String getDataResourceClassName(String name, File configDirectory) throws DataResourceAccessorCreationException {
        File file = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Attempting to read dataResourceClassConfig.xml");
            }
            file = new File(configDirectory, CLASS_CONFIG_FILENAME);
            Document classConfig = XMLUtilities.xmlFileToDOM(file.getAbsolutePath());
            NodeList nodes = classConfig.getElementsByTagName("dataResourceClass");
            Node node = nodes.item(0).getAttributes().getNamedItem("implementation");
            String result = node.getNodeValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Data resource class name is:" + result);
            }
            return result;
        }
        catch (XMLParseException e) {
            DAIFileContentError error = new DAIFileContentError(file, (Throwable)e);
            throw new DataResourceAccessorCreationException(name, error);
        }
        catch (DAIException e) {
            throw new DataResourceAccessorCreationException(name, e);
        }
    }

    private DataResourceAccessor createDataResourceAccessorInstance(String name, String className) throws DataResourceAccessorCreationException {
        try {
            Class<?> dataResourceAccessorClass = Class.forName(className);
            DataResourceAccessor dataResourceAccessor = (DataResourceAccessor)dataResourceAccessorClass.newInstance();
            return dataResourceAccessor;
        }
        catch (ClassNotFoundException e) {
            DAIClassNotFoundException ex = new DAIClassNotFoundException(className);
            throw new DataResourceAccessorCreationException(name, ex);
        }
        catch (InstantiationException e) {
            DAIClassCreateException ex = new DAIClassCreateException(className, e);
            throw new DataResourceAccessorCreationException(name, ex);
        }
        catch (IllegalAccessException e) {
            DAIClassCreateException ex = new DAIClassCreateException(className, e);
            throw new DataResourceAccessorCreationException(name, ex);
        }
        catch (ClassCastException e) {
            DAIClassMissingInterfaceException ex = new DAIClassMissingInterfaceException(className, DataResourceAccessor.class.getName());
            throw new DataResourceAccessorCreationException(name, ex);
        }
    }
}

