/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.webrowset.resultset.types;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import uk.org.ogsadai.common.BinaryLob;
import uk.org.ogsadai.common.CharacterLob;
import uk.org.ogsadai.converters.webrowset.resultset.types.TypeStrategy;

public class VarCharStrategy
extends TypeStrategy {
    private static final String COPYRIGHT_NOTICE = "(c) The University of Edinburgh 2002 - 2005.";

    public String getString(String data) {
        return data;
    }

    public InputStream getAsciiStream(String data) {
        if (data == null) {
            return null;
        }
        return new ByteArrayInputStream(data.getBytes());
    }

    public BigDecimal getBigDecimal(String data) throws SQLException {
        if (data == null) {
            return null;
        }
        try {
            return new BigDecimal(data);
        }
        catch (NumberFormatException e) {
            throw new SQLException("Cannot convert " + data + " to BigDecimal");
        }
    }

    public InputStream getBinaryStream(String data) {
        if (data == null) {
            return null;
        }
        return new ByteArrayInputStream(data.getBytes());
    }

    public BigInteger getBigInteger(String data) throws SQLException {
        if (data == null) {
            return null;
        }
        try {
            return new BigInteger(data);
        }
        catch (NumberFormatException e) {
            throw new SQLException("Cannot convert " + data + " to BigInteger");
        }
    }

    public Blob getBlob(String data) throws SQLException {
        if (data == null) {
            return null;
        }
        BinaryLob blob = new BinaryLob();
        blob.setBytes(1L, data.getBytes());
        return blob;
    }

    public boolean getBoolean(String data) throws SQLException {
        if (data == null) {
            return false;
        }
        return new Boolean(data);
    }

    public byte[] getBytes(String data) {
        if (data == null) {
            return null;
        }
        return data.getBytes();
    }

    public Reader getCharacterStream(String data) throws SQLException {
        if (data == null) {
            return null;
        }
        return new StringReader(data);
    }

    public Clob getClob(String data) throws SQLException {
        if (data == null) {
            return null;
        }
        CharacterLob clob = new CharacterLob();
        clob.setString(1L, data);
        return clob;
    }

    public Object getObject(String data) {
        return this.getString(data);
    }
}

