/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.webrowset.resultset.types;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import uk.org.ogsadai.converters.webrowset.resultset.types.ArrayStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.BigIntStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.BlobStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.BooleanStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.ClobStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.DateStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.DecimalStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.DoubleStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.FloatStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.IntegerStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.NumericStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.SmallIntStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.TimeStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.TimestampStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.TinyIntStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.TypeStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.VarCharStrategy;

public class TypeStrategyFactory {
    private static final String COPYRIGHT_NOTICE = "(c) The University of Edinburgh 2002 - 2005.";

    public static TypeStrategy createTypeStrategy(ResultSetMetaData metadata, int column) throws SQLException {
        int type = metadata.getColumnType(column);
        TypeStrategy strategy = null;
        switch (type) {
            case 2003: {
                strategy = new ArrayStrategy();
                break;
            }
            case -7: 
            case 16: {
                strategy = new BooleanStrategy();
                break;
            }
            case -6: {
                strategy = new TinyIntStrategy();
                break;
            }
            case 5: {
                strategy = new SmallIntStrategy();
                break;
            }
            case -5: {
                strategy = new BigIntStrategy();
                break;
            }
            case 4: {
                strategy = new IntegerStrategy();
                break;
            }
            case 3: {
                strategy = new DecimalStrategy();
                break;
            }
            case 6: 
            case 7: {
                strategy = new FloatStrategy();
                break;
            }
            case 8: {
                strategy = new DoubleStrategy();
                break;
            }
            case 2: {
                int scale = metadata.getScale(column);
                strategy = new NumericStrategy(scale);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                strategy = new VarCharStrategy();
                break;
            }
            case 93: {
                strategy = new TimestampStrategy();
                break;
            }
            case 92: {
                strategy = new TimeStrategy();
                break;
            }
            case 91: {
                strategy = new DateStrategy();
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                strategy = new BlobStrategy();
                break;
            }
            case 2005: {
                strategy = new ClobStrategy();
            }
            default: {
                throw new SQLException("Unknown column type: " + type);
            }
        }
        return strategy;
    }
}

