/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.webrowset.resultset.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import uk.org.ogsadai.converters.webrowset.resultset.types.TypeStrategy;

public class NumberStrategy
extends TypeStrategy {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";

    public boolean getBoolean(String data) throws SQLException {
        boolean result = false;
        if (data != null) {
            try {
                result = Double.parseDouble(data) != 0.0;
            }
            catch (NumberFormatException e) {
                throw new SQLException("Cannot convert " + data + " to double");
            }
        }
        return result;
    }

    public byte getByte(String data) throws SQLException {
        byte result = 0;
        if (data != null) {
            try {
                result = Byte.parseByte(data);
            }
            catch (NumberFormatException e) {
                throw new SQLException("Cannot convert " + data + " to double");
            }
        }
        return result;
    }

    public short getShort(String data) throws SQLException {
        short result = 0;
        if (data != null) {
            try {
                result = Short.parseShort(data);
            }
            catch (NumberFormatException e) {
                throw new SQLException("Cannot convert " + data + " to short");
            }
        }
        return result;
    }

    public int getInt(String data) throws SQLException {
        int result = 0;
        if (data != null) {
            try {
                result = Integer.parseInt(data);
            }
            catch (NumberFormatException e) {
                throw new SQLException("Cannot convert " + data + " to int");
            }
        }
        return result;
    }

    public long getLong(String data) throws SQLException {
        long result = 0L;
        if (data != null) {
            try {
                result = Long.parseLong(data);
            }
            catch (NumberFormatException e) {
                throw new SQLException("Cannot convert " + data + " to long");
            }
        }
        return result;
    }

    public double getDouble(String data) throws SQLException {
        double result = 0.0;
        if (data != null) {
            try {
                result = Double.parseDouble(data);
            }
            catch (NumberFormatException e) {
                throw new SQLException("Cannot convert " + data + " to double");
            }
        }
        return result;
    }

    public float getFloat(String data) throws SQLException {
        float result = 0.0f;
        if (data != null) {
            try {
                result = Float.parseFloat(data);
            }
            catch (NumberFormatException e) {
                throw new SQLException("Cannot convert " + data + " to float");
            }
        }
        return result;
    }

    public String getString(String data) throws SQLException {
        return data;
    }

    public BigDecimal getBigDecimal(String data) throws SQLException {
        if (data == null) {
            return null;
        }
        try {
            BigDecimal b = new BigDecimal(data);
            return b;
        }
        catch (NumberFormatException e) {
            throw new SQLException("Cannot convert " + data + " to BigDecimal");
        }
    }

    public BigInteger getBigInteger(String data) throws SQLException {
        if (data == null) {
            return null;
        }
        try {
            BigInteger b = new BigInteger(data);
            return b;
        }
        catch (NumberFormatException e) {
            throw new SQLException("Cannot convert " + data + " to BigInteger");
        }
    }
}

