/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.webrowset.resultset.types;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import uk.org.ogsadai.common.BinaryLob;
import uk.org.ogsadai.common.CharacterLob;
import uk.org.ogsadai.converters.webrowset.resultset.types.TypeStrategy;

public class ClobStrategy
extends TypeStrategy {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";

    public InputStream getAsciiStream(String data) throws SQLException {
        if (data == null) {
            return null;
        }
        return this.getClob(data).getAsciiStream();
    }

    public InputStream getBinaryStream(String data) {
        if (data == null) {
            return null;
        }
        return new ByteArrayInputStream(data.getBytes());
    }

    public Blob getBlob(String data) throws SQLException {
        BinaryLob blob = new BinaryLob();
        blob.setBytes(1L, data.getBytes());
        return blob;
    }

    public byte[] getBytes(String data) {
        if (data == null) {
            return null;
        }
        return data.getBytes();
    }

    public Reader getCharacterStream(String data) throws SQLException {
        if (data == null) {
            return null;
        }
        return this.getClob(data).getCharacterStream();
    }

    public Clob getClob(String data) throws SQLException {
        if (data == null) {
            return null;
        }
        CharacterLob clob = new CharacterLob();
        clob.setString(1L, data);
        return clob;
    }

    public String getString(String data) {
        return data;
    }

    public Object getObject(String data) throws SQLException {
        return this.getClob(data);
    }
}

