/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.webrowset.resultset;

import java.io.IOException;
import java.io.Reader;
import java.sql.ResultSet;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import uk.org.ogsadai.common.xml.XMLDocumentException;
import uk.org.ogsadai.common.xml.XMLParseException;
import uk.org.ogsadai.converters.webrowset.SAXWrappedException;
import uk.org.ogsadai.converters.webrowset.SQLWrappedException;
import uk.org.ogsadai.converters.webrowset.WebRowSetParser;
import uk.org.ogsadai.converters.webrowset.WebRowSetResultSetParseException;
import uk.org.ogsadai.converters.webrowset.resultset.ResultSetForwardOnly;
import uk.org.ogsadai.converters.webrowset.resultset.ResultSetScrollable;
import uk.org.ogsadai.exception.DAIIOException;

public class WebRowSetToResultSet {
    private static final String COPYRIGHT_NOTICE = "(c) The University of Edinburgh 2002 - 2005.";
    private int mType = 1003;
    private Reader mInput;

    public WebRowSetToResultSet(Reader reader) {
        this.mInput = reader;
    }

    public void setResultSetType(int type) throws IllegalArgumentException {
        if (type != 1004 && type != 1003) {
            throw new IllegalArgumentException("type must be one of ResultSet.TYPE_SCROLL_INSENSITIVE or ResultSet.TYPE_FORWARD_ONLY");
        }
        this.mType = type;
    }

    public ResultSet getResultSet() throws WebRowSetResultSetParseException {
        final WebRowSetParser parser = new WebRowSetParser();
        parser.setInput(this.mInput);
        if (this.mType == 1004) {
            ResultSetScrollable resultSet = new ResultSetScrollable();
            parser.setOutput(resultSet);
            try {
                parser.parse();
                return resultSet;
            }
            catch (SAXWrappedException e) {
                Exception cause = e.getWrappedException();
                if (cause instanceof SQLWrappedException) {
                    throw new WebRowSetResultSetParseException(((SQLWrappedException)cause).getWrappedException());
                }
                throw new WebRowSetResultSetParseException(cause);
            }
            catch (SAXParseException e) {
                throw new WebRowSetResultSetParseException(new XMLDocumentException(e));
            }
            catch (SAXException e) {
                throw new WebRowSetResultSetParseException(new XMLParseException(e));
            }
            catch (IOException e) {
                throw new WebRowSetResultSetParseException(new DAIIOException(e));
            }
        }
        final ResultSetForwardOnly resultSet = new ResultSetForwardOnly();
        parser.setOutput(resultSet);
        Thread thread = new Thread(){

            public void run() {
                try {
                    parser.parse();
                }
                catch (SAXWrappedException e) {
                    WebRowSetResultSetParseException ex = new WebRowSetResultSetParseException(e.getWrappedException());
                    resultSet.setError(ex);
                }
                catch (SAXException e) {
                    WebRowSetResultSetParseException ex = new WebRowSetResultSetParseException(new XMLParseException(e));
                    resultSet.setError(ex);
                }
                catch (IOException e) {
                    WebRowSetResultSetParseException ex = new WebRowSetResultSetParseException(new DAIIOException(e));
                    resultSet.setError(ex);
                }
                catch (Throwable e) {
                    WebRowSetResultSetParseException ex = new WebRowSetResultSetParseException(e);
                    resultSet.setError(ex);
                }
            }
        };
        thread.start();
        return resultSet;
    }
}

