/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.webrowset.resultset;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import uk.org.ogsadai.converters.webrowset.SQLWrappedException;
import uk.org.ogsadai.converters.webrowset.WebRowSetHandler;
import uk.org.ogsadai.converters.webrowset.resultset.types.TypeStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.TypeStrategyFactory;

public abstract class AbstractResultSet
implements ResultSet,
WebRowSetHandler {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";
    protected ResultSetMetaData mMetaData;
    private Map mColumnNames = new HashMap();
    private TypeStrategy[] mColStrategy;

    public abstract void putRow(Vector var1);

    public void putMetaData(ResultSetMetaData metadata) throws SQLException {
        this.mMetaData = metadata;
        int colcount = metadata.getColumnCount();
        this.mColStrategy = new TypeStrategy[colcount + 1];
        for (int i = 1; i <= colcount; ++i) {
            this.mColStrategy[i] = TypeStrategyFactory.createTypeStrategy(metadata, i);
            this.mColumnNames.put(metadata.getColumnName(i).toUpperCase(), new Integer(i));
        }
    }

    protected abstract String getColumn(int var1) throws SQLException;

    public int findColumn(String name) throws SQLException {
        Integer column = (Integer)this.mColumnNames.get(name.toUpperCase());
        if (column != null) {
            return column;
        }
        throw new SQLWrappedException(new IllegalArgumentException("No such column: " + name));
    }

    public int getConcurrency() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getFetchDirection() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getFetchSize() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public abstract int getRow() throws SQLException;

    public abstract int getType() throws SQLException;

    public abstract void afterLast() throws SQLException;

    public abstract void beforeFirst() throws SQLException;

    public void cancelRowUpdates() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void clearWarnings() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void close() throws SQLException {
    }

    public void deleteRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void insertRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void moveToCurrentRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void moveToInsertRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void refreshRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public abstract boolean first() throws SQLException;

    public abstract boolean isAfterLast() throws SQLException;

    public abstract boolean isBeforeFirst() throws SQLException;

    public abstract boolean isFirst() throws SQLException;

    public abstract boolean isLast() throws SQLException;

    public abstract boolean last() throws SQLException;

    public abstract boolean next() throws SQLException;

    public abstract boolean previous() throws SQLException;

    public boolean rowDeleted() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean rowInserted() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean rowUpdated() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean wasNull() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public byte getByte(int col) throws SQLException {
        return this.mColStrategy[col].getByte(this.getColumn(col));
    }

    public double getDouble(int col) throws SQLException {
        return this.mColStrategy[col].getDouble(this.getColumn(col));
    }

    public float getFloat(int col) throws SQLException {
        return this.mColStrategy[col].getFloat(this.getColumn(col));
    }

    public int getInt(int col) throws SQLException {
        return this.mColStrategy[col].getInt(this.getColumn(col));
    }

    public long getLong(int col) throws SQLException {
        return this.mColStrategy[col].getLong(this.getColumn(col));
    }

    public short getShort(int col) throws SQLException {
        return this.mColStrategy[col].getShort(this.getColumn(col));
    }

    public void setFetchDirection(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setFetchSize(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateNull(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public abstract boolean absolute(int var1) throws SQLException;

    public abstract boolean relative(int var1) throws SQLException;

    public boolean getBoolean(int col) throws SQLException {
        return this.mColStrategy[col].getBoolean(this.getColumn(col));
    }

    public byte[] getBytes(int col) throws SQLException {
        return this.mColStrategy[col].getBytes(this.getColumn(col));
    }

    public void updateByte(int arg0, byte arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateDouble(int arg0, double arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateFloat(int arg0, float arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateInt(int arg0, int arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateLong(int arg0, long arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateShort(int arg0, short arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBoolean(int arg0, boolean arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBytes(int arg0, byte[] arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public InputStream getAsciiStream(int col) throws SQLException {
        return this.mColStrategy[col].getAsciiStream(this.getColumn(col));
    }

    public InputStream getBinaryStream(int col) throws SQLException {
        return this.mColStrategy[col].getBinaryStream(this.getColumn(col));
    }

    public InputStream getUnicodeStream(int col) throws SQLException {
        return this.mColStrategy[col].getUnicodeStream(this.getColumn(col));
    }

    public void updateAsciiStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Reader getCharacterStream(int col) throws SQLException {
        return this.mColStrategy[col].getCharacterStream(this.getColumn(col));
    }

    public void updateCharacterStream(int arg0, Reader arg1, int arg2) {
        throw new UnsupportedOperationException();
    }

    public Object getObject(int col) throws SQLException {
        return this.mColStrategy[col].getObject(this.getColumn(col));
    }

    public void updateObject(int arg0, Object arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateObject(int arg0, Object arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getCursorName() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getString(int col) throws SQLException {
        return this.mColStrategy[col].getString(this.getColumn(col));
    }

    public void updateString(int arg0, String arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public byte getByte(String name) throws SQLException {
        return this.getByte(this.findColumn(name));
    }

    public double getDouble(String name) throws SQLException {
        return this.getDouble(this.findColumn(name));
    }

    public float getFloat(String name) throws SQLException {
        return this.getFloat(this.findColumn(name));
    }

    public int getInt(String name) throws SQLException {
        return this.getInt(this.findColumn(name));
    }

    public long getLong(String name) throws SQLException {
        return this.getLong(this.findColumn(name));
    }

    public short getShort(String name) throws SQLException {
        return this.getShort(this.findColumn(name));
    }

    public void updateNull(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(String name) throws SQLException {
        return this.getBoolean(this.findColumn(name));
    }

    public byte[] getBytes(String name) throws SQLException {
        return this.getBytes(this.findColumn(name));
    }

    public void updateByte(String arg0, byte arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateDouble(String arg0, double arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateFloat(String arg0, float arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateInt(String arg0, int arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateLong(String arg0, long arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateShort(String arg0, short arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBoolean(String arg0, boolean arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBytes(String arg0, byte[] arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(int col) throws SQLException {
        return this.mColStrategy[col].getBigDecimal(this.getColumn(col));
    }

    public BigDecimal getBigDecimal(int col, int arg1) throws SQLException {
        return this.mColStrategy[col].getBigDecimal(this.getColumn(col), arg1);
    }

    public void updateBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public URL getURL(int col) throws SQLException {
        return this.mColStrategy[col].getURL(this.getColumn(col));
    }

    public Array getArray(int col) throws SQLException {
        return this.mColStrategy[col].getArray(this.getColumn(col));
    }

    public void updateArray(int arg0, Array arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Blob getBlob(int col) throws SQLException {
        return this.mColStrategy[col].getBlob(this.getColumn(col));
    }

    public void updateBlob(int arg0, Blob arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Clob getClob(int col) throws SQLException {
        return this.mColStrategy[col].getClob(this.getColumn(col));
    }

    public void updateClob(int arg0, Clob arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Date getDate(int col) throws SQLException {
        return this.mColStrategy[col].getDate(this.getColumn(col));
    }

    public void updateDate(int arg0, Date arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Ref getRef(int col) throws SQLException {
        return this.mColStrategy[col].getRef(this.getColumn(col));
    }

    public void updateRef(int arg0, Ref arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.mMetaData;
    }

    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Statement getStatement() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Time getTime(int col) throws SQLException {
        return this.mColStrategy[col].getTime(this.getColumn(col));
    }

    public void updateTime(int arg0, Time arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Timestamp getTimestamp(int col) throws SQLException {
        return this.mColStrategy[col].getTimestamp(this.getColumn(col));
    }

    public void updateTimestamp(int arg0, Timestamp arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public InputStream getAsciiStream(String name) throws SQLException {
        return this.getAsciiStream(this.findColumn(name));
    }

    public InputStream getBinaryStream(String name) throws SQLException {
        return this.getBinaryStream(this.findColumn(name));
    }

    public InputStream getUnicodeStream(String name) throws SQLException {
        return this.getUnicodeStream(this.findColumn(name));
    }

    public void updateAsciiStream(String arg0, InputStream arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBinaryStream(String arg0, InputStream arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Reader getCharacterStream(String name) throws SQLException {
        return this.getCharacterStream(this.findColumn(name));
    }

    public void updateCharacterStream(String arg0, Reader arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Object getObject(String name) throws SQLException {
        return this.getObject(this.findColumn(name));
    }

    public void updateObject(String arg0, Object arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateObject(String arg0, Object arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Object getObject(int col, Map arg1) throws SQLException {
        return this.mColStrategy[col].getObject(this.getColumn(col));
    }

    public String getString(String name) throws SQLException {
        return this.getString(this.findColumn(name));
    }

    public void updateString(String arg0, String arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(String name) throws SQLException {
        return this.getBigDecimal(this.findColumn(name));
    }

    public BigDecimal getBigDecimal(String name, int arg1) throws SQLException {
        return this.getBigDecimal(this.findColumn(name), arg1);
    }

    public void updateBigDecimal(String arg0, BigDecimal arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public URL getURL(String name) throws SQLException {
        return this.getURL(this.findColumn(name));
    }

    public Array getArray(String name) throws SQLException {
        return this.getArray(this.findColumn(name));
    }

    public void updateArray(String arg0, Array arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Blob getBlob(String name) throws SQLException {
        return this.getBlob(this.findColumn(name));
    }

    public void updateBlob(String arg0, Blob arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Clob getClob(String name) throws SQLException {
        return this.getClob(this.findColumn(name));
    }

    public void updateClob(String arg0, Clob arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Date getDate(String name) throws SQLException {
        return this.getDate(this.findColumn(name));
    }

    public void updateDate(String arg0, Date arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Date getDate(int col, Calendar calendar) throws SQLException {
        return this.mColStrategy[col].getDate(this.getColumn(col), calendar);
    }

    public Ref getRef(String name) throws SQLException {
        return this.getRef(this.findColumn(name));
    }

    public void updateRef(String arg0, Ref arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Time getTime(String name) throws SQLException {
        return this.getTime(this.findColumn(name));
    }

    public void updateTime(String arg0, Time arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Time getTime(int col, Calendar calendar) throws SQLException {
        return this.mColStrategy[col].getTime(this.getColumn(col), calendar);
    }

    public Timestamp getTimestamp(String name) throws SQLException {
        return this.getTimestamp(this.findColumn(name));
    }

    public void updateTimestamp(String arg0, Timestamp arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Timestamp getTimestamp(int col, Calendar calendar) throws SQLException {
        return this.mColStrategy[col].getTimestamp(this.getColumn(col), calendar);
    }

    public Object getObject(String arg0, Map arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Date getDate(String name, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(name), calendar);
    }

    public Time getTime(String name, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(name), calendar);
    }

    public Timestamp getTimestamp(String name, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(name), calendar);
    }
}

