/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.webrowset.metadata;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import uk.org.ogsadai.converters.webrowset.metadata.MetaDataContainer;
import uk.org.ogsadai.converters.webrowset.metadata.MetaDataElement;

public class ColumnMetaData
implements ResultSetMetaData {
    private static final String COPYRIGHT_NOTICE = "(c) The University of Edinburgh 2002 - 2005.";
    private int mColumnCount = 0;
    private MetaDataContainer[] mMetaData;

    public void setColumnCount(int count) {
        this.mColumnCount = count;
        this.mMetaData = new MetaDataContainer[count + 1];
        for (int i = 1; i <= count; ++i) {
            this.mMetaData[i] = new MetaDataContainer();
        }
    }

    public void storeData(int column, String name, String value) {
        MetaDataElement element = this.mMetaData[column].getNextElement();
        if (element == null) {
            throw new IllegalStateException("There is no more metadata expected for column " + column);
        }
        if (!element.getName().equals(name)) {
            throw new IllegalArgumentException("name must be " + element.getName());
        }
        element.setValue(value);
    }

    public int getColumnCount() throws SQLException {
        return this.mColumnCount;
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        return this.mMetaData[column].mColumnDisplaySize.getValue();
    }

    public int getColumnType(int column) throws SQLException {
        return this.mMetaData[column].mColumnType.getValue();
    }

    public int getPrecision(int column) throws SQLException {
        return this.mMetaData[column].mColumnPrecision.getValue();
    }

    public int getScale(int column) throws SQLException {
        return this.mMetaData[column].mColumnScale.getValue();
    }

    public int isNullable(int column) throws SQLException {
        return this.mMetaData[column].mNullable.getValue();
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        return this.mMetaData[column].mAutoIncrement.getValue();
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        return this.mMetaData[column].mCaseSensitive.getValue();
    }

    public boolean isCurrency(int column) throws SQLException {
        return this.mMetaData[column].mCurrency.getValue();
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    public boolean isReadOnly(int arg0) throws SQLException {
        return true;
    }

    public boolean isSearchable(int column) throws SQLException {
        return this.mMetaData[column].mSearchable.getValue();
    }

    public boolean isSigned(int column) throws SQLException {
        return this.mMetaData[column].mSigned.getValue();
    }

    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    public String getCatalogName(int column) throws SQLException {
        return this.mMetaData[column].mCatalogName.getValue();
    }

    public String getColumnClassName(int column) throws SQLException {
        return null;
    }

    public String getColumnLabel(int column) throws SQLException {
        return this.mMetaData[column].mColumnLabel.getValue();
    }

    public String getColumnName(int column) throws SQLException {
        return this.mMetaData[column].mColumnName.getValue();
    }

    public String getColumnTypeName(int column) throws SQLException {
        return this.mMetaData[column].mColumnTypeName.getValue();
    }

    public String getSchemaName(int column) throws SQLException {
        return this.mMetaData[column].mSchemaName.getValue();
    }

    public String getTableName(int column) throws SQLException {
        return this.mMetaData[column].mTableName.getValue();
    }
}

