/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.webrowset;

import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import java.util.Vector;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import uk.org.ogsadai.converters.webrowset.ElementHandler;
import uk.org.ogsadai.converters.webrowset.SAXWrappedException;
import uk.org.ogsadai.converters.webrowset.WebRowSetHandler;
import uk.org.ogsadai.converters.webrowset.WebRowSetParseException;
import uk.org.ogsadai.converters.webrowset.metadata.ColumnMetaData;
import uk.org.ogsadai.converters.webrowset.resultset.types.TypeStrategy;
import uk.org.ogsadai.exception.ExternalModuleException;

public class WebRowSetParser
extends DefaultHandler {
    private static final String COPYRIGHT_NOTICE = "(c) The University of Edinburgh 2002 - 2005.";
    private SAXParser mParser;
    private InputSource mInput;
    private WebRowSetHandler mOutput;
    private ElementHandler mHandler;
    private Locator mLocator;

    public WebRowSetParser() throws ExternalModuleException {
        try {
            this.mParser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new ExternalModuleException(e);
        }
        catch (SAXException e) {
            throw new ExternalModuleException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new ExternalModuleException(e);
        }
    }

    public void setInput(Reader reader) {
        this.mInput = new InputSource(reader);
    }

    public void setOutput(WebRowSetHandler handler) {
        this.mOutput = handler;
    }

    public void setParsingStrategy(ElementHandler strategy) {
        this.mHandler = strategy;
    }

    public void parse() throws SAXException, IOException {
        this.mHandler = new PropertiesHandler();
        this.mParser.parse(this.mInput, (DefaultHandler)this);
    }

    public void setDocumentLocator(Locator locator) {
        this.mLocator = locator;
    }

    public void startElement(String uri, String localName, String qName, Attributes attr) throws SAXException {
        this.mHandler.startElement(uri, localName, qName, attr);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.mHandler.endElement(uri, localName, qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.mHandler.characters(ch, start, length);
    }

    private class DataHandler
    implements ElementHandler {
        private static final String COPYRIGHT_NOTICE = "(c) The University of Edinburgh 2002 - 2005.";
        private TypeStrategy mTypeStrategy;
        private StringBuffer mColumnString = null;
        private Vector mRow;

        private DataHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attr) throws SAXException {
            if (qName.equals("columnValue")) {
                this.mColumnString = new StringBuffer();
            } else if (qName.equals("currentRow")) {
                this.mRow = new Vector();
            } else if (qName.equals("data")) {
                // empty if block
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("columnValue")) {
                if (this.mRow == null) {
                    IllegalStateException ex = new IllegalStateException("No current row");
                    throw new SAXParseException(ex.getLocalizedMessage(), WebRowSetParser.this.mLocator, ex);
                }
                if (this.mColumnString != null) {
                    this.mRow.add(this.mColumnString.toString());
                } else {
                    this.mRow.add(null);
                }
                this.mColumnString = null;
            } else if (qName.equals("null")) {
                this.mColumnString = null;
            } else if (qName.equals("currentRow")) {
                WebRowSetParser.this.mOutput.putRow(this.mRow);
            } else if (qName.equals("webRowSet")) {
                WebRowSetParser.this.mOutput.putRow(null);
            }
        }

        public void characters(char[] ch, int start, int length) {
            if (this.mColumnString != null) {
                this.mColumnString.append(ch, start, length);
            }
        }
    }

    private class MetaDataHandler
    implements ElementHandler {
        private static final String COPYRIGHT_NOTICE = "(c) The University of Edinburgh 2002 - 2005.";
        private ColumnMetaData mMetaData = new ColumnMetaData();
        private StringBuffer mValue;
        private int mCurrentColumn;
        private final int META_DATA = 1;
        private final int COLUMN_COUNT = 2;
        private int mExpected = 1;

        private MetaDataHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attr) throws SAXException {
            if (this.mExpected > 0) {
                if (this.mExpected == 1) {
                    if (!qName.equals("metadata")) {
                        WebRowSetParseException ex = new WebRowSetParseException(qName);
                        throw new SAXParseException(ex.getLocalizedMessage(), WebRowSetParser.this.mLocator, ex);
                    }
                    this.mExpected = 2;
                } else if (this.mExpected == 2) {
                    if (!qName.equals("column-count")) {
                        WebRowSetParseException ex = new WebRowSetParseException(qName);
                        throw new SAXParseException(ex.getLocalizedMessage(), WebRowSetParser.this.mLocator, ex);
                    }
                    this.mExpected = 0;
                    this.mValue = new StringBuffer();
                }
            } else {
                this.mValue = new StringBuffer();
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("metadata")) {
                WebRowSetParser.this.mHandler = new DataHandler();
                try {
                    WebRowSetParser.this.mOutput.putMetaData(this.mMetaData);
                }
                catch (SQLException e) {
                    throw new SAXWrappedException(e);
                }
            } else if (qName.equals("column-index")) {
                this.mCurrentColumn = Integer.parseInt(this.mValue.toString());
            } else if (qName.equals("column-definition")) {
                this.mCurrentColumn = 0;
            } else if (qName.equals("column-count")) {
                this.mMetaData.setColumnCount(Integer.parseInt(this.mValue.toString()));
            } else {
                this.mMetaData.storeData(this.mCurrentColumn, qName, this.mValue.toString());
            }
        }

        public void characters(char[] ch, int start, int length) {
            if (this.mValue != null) {
                this.mValue.append(ch, start, length);
            }
        }
    }

    private class PropertiesHandler
    implements ElementHandler {
        private static final String COPYRIGHT_NOTICE = "(c) The University of Edinburgh 2002 - 2005.";
        private String mExpected = "webRowSet";

        private PropertiesHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attr) throws SAXException {
            if (this.mExpected != null && !qName.equals(this.mExpected)) {
                WebRowSetParseException ex = new WebRowSetParseException(qName);
                throw new SAXParseException(ex.getLocalizedMessage(), WebRowSetParser.this.mLocator, ex);
            }
            this.mExpected = qName.equals("webRowSet") ? "properties" : null;
        }

        public void endElement(String uri, String localName, String qName) {
            if (qName.equals("properties")) {
                WebRowSetParser.this.mHandler = new MetaDataHandler();
            }
        }

        public void characters(char[] ch, int start, int length) {
        }
    }
}

