/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.resultset.webrowset;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import uk.org.ogsadai.converters.resultset.ResultSetHandler;
import uk.org.ogsadai.converters.resultset.ResultSetHandlerException;
import uk.org.ogsadai.converters.resultset.StrategicResultSetHandler;
import uk.org.ogsadai.converters.resultset.webrowset.WebRowSetColumnStrategyFactory;

public class WebRowSetResultSetHandler
extends StrategicResultSetHandler
implements ResultSetHandler {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";
    private final String ROWSTART_TAG = "<currentRow>\n";
    private final String ROWEND_TAG = "</currentRow>";
    private final String COLSTART_TAG = "<columnValue>";
    private final String COLEND_TAG = "</columnValue>\n";

    public WebRowSetResultSetHandler(ResultSet rs) throws ResultSetHandlerException {
        super(rs, new WebRowSetColumnStrategyFactory());
    }

    public void header(StringBuffer output, ResultSet rs) throws ResultSetHandlerException {
        try {
            StringBuffer header = new StringBuffer();
            header.append("<webRowSet ");
            header.append("xmlns=\"http://java.sun.com/xml/ns/jdbc\" ");
            header.append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
            header.append("xsi:schemaLocation=\"http://java.sun.com/xml/ns/jdbc ");
            header.append("http://java.sun.com/xml/ns/jdbc/webrowset.xsd\">\n");
            header.append(this.properties(rs));
            header.append(this.metadata(rs.getMetaData()));
            header.append("\n<data>");
            output.append(header);
        }
        catch (Exception e) {
            throw new ResultSetHandlerException(e);
        }
    }

    public void rowStart(StringBuffer output) {
        output.append("<currentRow>\n");
    }

    public void columnStart(StringBuffer output) {
        output.append("<columnValue>");
    }

    public void columnEnd(StringBuffer output) {
        output.append("</columnValue>\n");
    }

    public void rowEnd(StringBuffer output) {
        output.append("</currentRow>");
    }

    public void footer(StringBuffer output) {
        output.append("</data>\n</webRowSet>");
    }

    private String properties(ResultSet rs) throws ResultSetHandlerException {
        try {
            int rowsetType;
            String property;
            StringBuffer properties = new StringBuffer("<properties>\n");
            properties.append("<command></command>\n");
            properties.append("<concurrency>");
            properties.append(rs.getConcurrency());
            properties.append("</concurrency>\n");
            properties.append("<datasource></datasource>\n");
            properties.append("<escape-processing>true</escape-processing>\n");
            try {
                property = String.valueOf(rs.getFetchDirection());
            }
            catch (Exception e) {
                property = "";
            }
            properties.append("<fetch-direction>");
            properties.append(property);
            properties.append("</fetch-direction>\n");
            try {
                property = String.valueOf(rs.getFetchSize());
            }
            catch (Exception e) {
                property = "";
            }
            properties.append("<fetch-size>");
            properties.append(property);
            properties.append("</fetch-size>\n");
            properties.append("<isolation-level>0</isolation-level>\n");
            properties.append("<key-columns></key-columns>\n");
            properties.append("<map></map>\n");
            Statement statement = rs.getStatement();
            try {
                property = String.valueOf(statement.getMaxFieldSize());
            }
            catch (Exception e) {
                property = "";
            }
            properties.append("<max-field-size>");
            properties.append(property);
            properties.append("</max-field-size>\n");
            try {
                property = String.valueOf(statement.getMaxRows());
            }
            catch (Exception e) {
                property = "";
            }
            properties.append("<max-rows>");
            properties.append(property);
            properties.append("</max-rows>\n");
            try {
                property = String.valueOf(statement.getQueryTimeout());
            }
            catch (Exception e) {
                property = "";
            }
            properties.append("<query-timeout>");
            properties.append(property);
            properties.append("</query-timeout>\n");
            properties.append("<read-only>true</read-only>\n");
            try {
                rowsetType = rs.getType();
            }
            catch (Exception e) {
                rowsetType = -1;
            }
            String sType = "";
            switch (rowsetType) {
                case 1003: {
                    sType = "ResultSet.TYPE_FORWARD_ONLY";
                    break;
                }
                case 1004: {
                    sType = "ResultSet.TYPE_SCROLL_INSENSITIVE";
                    break;
                }
                case 1005: {
                    sType = "ResultSet.TYPE_SCROLL_SENSITIVE";
                }
            }
            properties.append("<rowset-type>");
            properties.append(sType);
            properties.append("</rowset-type>\n");
            properties.append("<show-deleted>false</show-deleted>\n");
            properties.append("<table-name></table-name>\n");
            properties.append("<url></url>\n");
            properties.append("<sync-provider>\n");
            properties.append("<sync-provider-name/>\n");
            properties.append("<sync-provider-vendor/>\n");
            properties.append("<sync-provider-version/>\n");
            properties.append("<sync-provider-grade/>\n");
            properties.append("<data-source-lock/>\n");
            properties.append("</sync-provider>\n");
            properties.append("</properties>\n");
            return properties.toString();
        }
        catch (Exception e) {
            throw new ResultSetHandlerException(e);
        }
    }

    private String metadata(ResultSetMetaData metaData) throws ResultSetHandlerException {
        try {
            StringBuffer metadata = new StringBuffer("<metadata>\n");
            int noOfCols = metaData.getColumnCount();
            metadata.append("<column-count>" + Integer.toString(noOfCols) + "</column-count>\n");
            for (int i = 1; i <= noOfCols; ++i) {
                metadata.append("<column-definition>\n");
                metadata.append("<column-index>");
                metadata.append(i);
                metadata.append("</column-index>\n");
                metadata.append("<auto-increment>");
                metadata.append(metaData.isAutoIncrement(i));
                metadata.append("</auto-increment>\n");
                metadata.append("<case-sensitive>");
                metadata.append(metaData.isCaseSensitive(i));
                metadata.append("</case-sensitive>\n");
                metadata.append("<currency>");
                metadata.append(metaData.isCurrency(i));
                metadata.append("</currency>\n");
                metadata.append("<nullable>");
                metadata.append(metaData.isNullable(i));
                metadata.append("</nullable>\n");
                metadata.append("<signed>");
                metadata.append(metaData.isSigned(i));
                metadata.append("</signed>\n");
                metadata.append("<searchable>");
                metadata.append(metaData.isSearchable(i));
                metadata.append("</searchable>\n");
                metadata.append("<column-display-size>");
                metadata.append(metaData.getColumnDisplaySize(i));
                metadata.append("</column-display-size>\n");
                metadata.append("<column-label>");
                metadata.append(metaData.getColumnLabel(i));
                metadata.append("</column-label>\n");
                metadata.append("<column-name>");
                metadata.append(metaData.getColumnName(i));
                metadata.append("</column-name>\n");
                metadata.append("<schema-name>");
                metadata.append(metaData.getSchemaName(i));
                metadata.append("</schema-name>\n");
                metadata.append("<column-precision>");
                if (metaData.getColumnType(i) == 2004) {
                    metadata.append("0");
                } else {
                    metadata.append(metaData.getPrecision(i));
                }
                metadata.append("</column-precision>\n");
                metadata.append("<column-scale>");
                metadata.append(metaData.getScale(i));
                metadata.append("</column-scale>\n");
                metadata.append("<table-name>");
                metadata.append(metaData.getTableName(i));
                metadata.append("</table-name>\n");
                metadata.append("<catalog-name>");
                metadata.append(metaData.getCatalogName(i));
                metadata.append("</catalog-name>\n");
                metadata.append("<column-type>");
                metadata.append(metaData.getColumnType(i));
                metadata.append("</column-type>\n");
                metadata.append("<column-type-name>");
                metadata.append(metaData.getColumnTypeName(i));
                metadata.append("</column-type-name>\n");
                metadata.append("</column-definition>\n");
            }
            metadata.append("</metadata>");
            return metadata.toString();
        }
        catch (Exception e) {
            throw new ResultSetHandlerException(e);
        }
    }
}

