/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.resultset.webrowset;

import uk.org.ogsadai.converters.resultset.ColumnStrategy;
import uk.org.ogsadai.converters.resultset.ColumnStrategyFactory;
import uk.org.ogsadai.converters.resultset.webrowset.BinaryColumnStrategy;
import uk.org.ogsadai.converters.resultset.webrowset.NumberColumnStrategy;
import uk.org.ogsadai.converters.resultset.webrowset.TextColumnStrategy;
import uk.org.ogsadai.converters.resultset.webrowset.UnknownColumnStrategy;
import uk.org.ogsadai.converters.resultset.webrowset.UnsupportedColumnStrategy;

public class WebRowSetColumnStrategyFactory
implements ColumnStrategyFactory {
    private static final String COPYRIGHT_NOTICE = "(c) The University of Edinburgh 2002 - 2005.";

    public ColumnStrategy createColumnStrategy(int sqlType) {
        ColumnStrategy strategy = null;
        switch (sqlType) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                strategy = new NumberColumnStrategy();
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                strategy = new TextColumnStrategy();
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                strategy = new BinaryColumnStrategy();
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                strategy = new TextColumnStrategy();
                break;
            }
            case 0: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2006: {
                strategy = new UnsupportedColumnStrategy();
                break;
            }
            default: {
                strategy = new UnknownColumnStrategy();
            }
        }
        return strategy;
    }
}

