/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.resultset.webrowset;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import uk.org.ogsadai.converters.resultset.ColumnStrategy;

public class TextColumnStrategy
implements ColumnStrategy {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";
    private static char[] charBuffer;
    private static int charBufferSize;

    public void convertField(StringBuffer output, ResultSet rs, int column) throws SQLException, IOException {
        String value = rs.getString(column);
        if (value == null) {
            output.append("<null/>");
        } else {
            String text = this.replaceSpecialCharacters(value);
            output.append(text);
        }
    }

    private String replaceSpecialCharacters(String input) {
        if (input.length() * 6 > charBufferSize) {
            charBufferSize = input.length() * 6;
            charBuffer = new char[charBufferSize];
        }
        char[] charArray = input.toCharArray();
        int bufferIdx = 0;
        for (int i = 0; i < charArray.length; ++i) {
            char charAt = charArray[i];
            if (charAt == '&') {
                TextColumnStrategy.charBuffer[bufferIdx++] = 38;
                TextColumnStrategy.charBuffer[bufferIdx++] = 97;
                TextColumnStrategy.charBuffer[bufferIdx++] = 109;
                TextColumnStrategy.charBuffer[bufferIdx++] = 112;
                TextColumnStrategy.charBuffer[bufferIdx] = 59;
            } else if (charAt == '>') {
                TextColumnStrategy.charBuffer[bufferIdx++] = 38;
                TextColumnStrategy.charBuffer[bufferIdx++] = 103;
                TextColumnStrategy.charBuffer[bufferIdx++] = 116;
                TextColumnStrategy.charBuffer[bufferIdx] = 59;
            } else if (charAt == '<') {
                TextColumnStrategy.charBuffer[bufferIdx++] = 38;
                TextColumnStrategy.charBuffer[bufferIdx++] = 108;
                TextColumnStrategy.charBuffer[bufferIdx++] = 116;
                TextColumnStrategy.charBuffer[bufferIdx] = 59;
            } else if (charAt == '\"') {
                TextColumnStrategy.charBuffer[bufferIdx++] = 38;
                TextColumnStrategy.charBuffer[bufferIdx++] = 113;
                TextColumnStrategy.charBuffer[bufferIdx++] = 117;
                TextColumnStrategy.charBuffer[bufferIdx++] = 111;
                TextColumnStrategy.charBuffer[bufferIdx++] = 116;
                TextColumnStrategy.charBuffer[bufferIdx] = 59;
            } else if (charAt == '\'') {
                TextColumnStrategy.charBuffer[bufferIdx++] = 38;
                TextColumnStrategy.charBuffer[bufferIdx++] = 97;
                TextColumnStrategy.charBuffer[bufferIdx++] = 112;
                TextColumnStrategy.charBuffer[bufferIdx++] = 111;
                TextColumnStrategy.charBuffer[bufferIdx++] = 115;
                TextColumnStrategy.charBuffer[bufferIdx] = 59;
            } else {
                TextColumnStrategy.charBuffer[bufferIdx] = charAt;
            }
            ++bufferIdx;
        }
        return new String(charBuffer, 0, bufferIdx);
    }

    static {
        charBufferSize = 0;
    }
}

