/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.resultset.csv;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import uk.org.ogsadai.converters.csv.CSVConfigurator;
import uk.org.ogsadai.converters.resultset.ColumnStrategy;

public class TextColumnStrategy
implements ColumnStrategy {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";
    private CSVConfigurator mConfigurator;
    private static char[] charBuffer;
    private static int charBufferSize;

    public TextColumnStrategy(CSVConfigurator configurator) {
        this.mConfigurator = configurator;
    }

    public void convertField(StringBuffer output, ResultSet rs, int column) throws SQLException, IOException {
        String value = rs.getString(column);
        if (this.mConfigurator.isMEscapeFields()) {
            if (value == null) {
                output.append('\"');
                output.append(this.mConfigurator.getMNullDataStr());
                output.append('\"');
            } else {
                output.append(this.prepareField(value));
            }
        } else if (value == null) {
            output.append(this.mConfigurator.getMNullDataStr());
        } else {
            output.append(value);
        }
    }

    private String prepareField(String input) {
        if (input.length() * 2 > charBufferSize) {
            charBufferSize = input.length() * 2;
            charBuffer = new char[charBufferSize];
        }
        char[] charArray = input.toCharArray();
        int bufferIdx = 0;
        boolean replaced = false;
        TextColumnStrategy.charBuffer[bufferIdx++] = 34;
        for (int i = 0; i < charArray.length; ++i) {
            char charAt = charArray[i];
            if (charAt == '\"') {
                TextColumnStrategy.charBuffer[bufferIdx++] = 34;
                TextColumnStrategy.charBuffer[bufferIdx] = 34;
                replaced = true;
            } else {
                TextColumnStrategy.charBuffer[bufferIdx] = charAt;
            }
            ++bufferIdx;
        }
        TextColumnStrategy.charBuffer[bufferIdx++] = 34;
        return new String(charBuffer, 0, bufferIdx);
    }

    static {
        charBufferSize = 0;
    }
}

