/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.resultset.csv;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import uk.org.ogsadai.converters.csv.CSVConfigurator;
import uk.org.ogsadai.converters.resultset.ResultSetHandler;
import uk.org.ogsadai.converters.resultset.ResultSetHandlerException;
import uk.org.ogsadai.converters.resultset.StrategicResultSetHandler;
import uk.org.ogsadai.converters.resultset.csv.CSVColumnStrategyFactory;

public class CSVResultSetHandler
extends StrategicResultSetHandler
implements ResultSetHandler {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";
    private CSVConfigurator mConfigurator;
    private boolean rowJustStarted;

    public CSVResultSetHandler(ResultSet rs, CSVConfigurator configurator) throws ResultSetHandlerException {
        super(rs, new CSVColumnStrategyFactory(configurator));
        this.mConfigurator = configurator;
    }

    public void header(StringBuffer output, ResultSet rs) throws ResultSetHandlerException {
        if (this.mConfigurator.isMIncludeHeader()) {
            try {
                output.append(this.metadata(rs.getMetaData()));
            }
            catch (Exception e) {
                throw new ResultSetHandlerException(e);
            }
        }
    }

    public void rowStart(StringBuffer output) {
        this.rowJustStarted = true;
    }

    public void columnStart(StringBuffer output) {
        if (this.rowJustStarted) {
            this.rowJustStarted = false;
        } else {
            output.append(this.mConfigurator.getMDelimiter());
        }
    }

    public void columnEnd(StringBuffer output) {
    }

    public void rowEnd(StringBuffer output) {
        output.append(this.mConfigurator.getMLineBreakChars());
    }

    public void footer(StringBuffer output) {
    }

    private String metadata(ResultSetMetaData metaData) throws ResultSetHandlerException {
        try {
            int i;
            StringBuffer header = new StringBuffer();
            for (i = 1; i < metaData.getColumnCount(); ++i) {
                if (this.mConfigurator.isMEscapeFields()) {
                    header.append("\"");
                    header.append(metaData.getColumnName(i).replaceAll("\"", "\"\""));
                    header.append("\"");
                } else {
                    header.append(metaData.getColumnName(i));
                }
                header.append(this.mConfigurator.getMDelimiter());
            }
            if (this.mConfigurator.isMEscapeFields()) {
                header.append("\"");
                header.append(metaData.getColumnName(i));
                header.append("\"");
            } else {
                header.append(metaData.getColumnName(i));
            }
            header.append(this.mConfigurator.getMLineBreakChars());
            return header.toString();
        }
        catch (Exception e) {
            throw new ResultSetHandlerException(e);
        }
    }
}

