/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.resultset.csv;

import uk.org.ogsadai.converters.csv.CSVConfigurator;
import uk.org.ogsadai.converters.resultset.ColumnStrategy;
import uk.org.ogsadai.converters.resultset.ColumnStrategyFactory;
import uk.org.ogsadai.converters.resultset.csv.BinaryColumnStrategy;
import uk.org.ogsadai.converters.resultset.csv.NumberColumnStrategy;
import uk.org.ogsadai.converters.resultset.csv.TextColumnStrategy;
import uk.org.ogsadai.converters.resultset.csv.UnknownColumnStrategy;
import uk.org.ogsadai.converters.resultset.csv.UnsupportedColumnStrategy;

public class CSVColumnStrategyFactory
implements ColumnStrategyFactory {
    private static final String COPYRIGHT_NOTICE = "(c) The University of Edinburgh 2002 - 2005.";
    private CSVConfigurator mConfigurator;

    public CSVColumnStrategyFactory(CSVConfigurator configurator) {
        this.mConfigurator = configurator == null ? new CSVConfigurator() : configurator;
    }

    public ColumnStrategy createColumnStrategy(int sqlType) {
        ColumnStrategy strategy = null;
        switch (sqlType) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                strategy = new NumberColumnStrategy(this.mConfigurator);
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                strategy = new TextColumnStrategy(this.mConfigurator);
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                strategy = new TextColumnStrategy(this.mConfigurator);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                strategy = new BinaryColumnStrategy(this.mConfigurator);
                break;
            }
            case 0: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2006: {
                strategy = new UnsupportedColumnStrategy();
                break;
            }
            default: {
                strategy = new UnknownColumnStrategy();
            }
        }
        return strategy;
    }
}

