/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.resultset.csv;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import uk.org.ogsadai.common.Base64;
import uk.org.ogsadai.converters.csv.CSVConfigurator;
import uk.org.ogsadai.converters.resultset.ColumnStrategy;

public class BinaryColumnStrategy
implements ColumnStrategy {
    private static final String COPYRIGHT_NOTICE = "(c) The University of Edinburgh 2002 - 2006.";
    private CSVConfigurator mConfigurator;

    public BinaryColumnStrategy(CSVConfigurator configurator) {
        this.mConfigurator = configurator;
    }

    public void convertField(StringBuffer output, ResultSet rs, int column) throws SQLException, IOException {
        InputStream stream = rs.getBinaryStream(column);
        if (stream != null) {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] bytes = new byte[2048];
            int read = 0;
            while ((read = stream.read(bytes)) >= 0) {
                buffer.write(bytes, 0, read);
            }
            byte[] value = buffer.toByteArray();
            if (value != null && value.length > 0) {
                output.append("\"");
                output.append(new String(new Base64().encode(value)));
                output.append("\"");
            }
        } else {
            output.append(this.mConfigurator.getMNullDataStr());
        }
    }
}

