/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.resultset;

import java.sql.ResultSet;
import java.sql.SQLException;
import uk.org.ogsadai.converters.resultset.ColumnStrategy;
import uk.org.ogsadai.converters.resultset.ColumnStrategyFactory;
import uk.org.ogsadai.converters.resultset.ResultSetHandler;
import uk.org.ogsadai.converters.resultset.ResultSetHandlerColumnException;
import uk.org.ogsadai.converters.resultset.ResultSetHandlerException;

public abstract class StrategicResultSetHandler
implements ResultSetHandler {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";
    private final ColumnStrategy[] mStrategies;

    public StrategicResultSetHandler(ResultSet rs, ColumnStrategyFactory factory) throws ResultSetHandlerException {
        try {
            this.mStrategies = new ColumnStrategy[rs.getMetaData().getColumnCount()];
            for (int i = 0; i < this.mStrategies.length; ++i) {
                int type = rs.getMetaData().getColumnType(i + 1);
                this.mStrategies[i] = factory.createColumnStrategy(type);
            }
        }
        catch (SQLException e) {
            throw new ResultSetHandlerException(e);
        }
    }

    public final void field(StringBuffer output, ResultSet resultSet, int column) throws ResultSetHandlerException {
        try {
            this.mStrategies[column - 1].convertField(output, resultSet, column);
        }
        catch (Exception e) {
            throw new ResultSetHandlerException(new ResultSetHandlerColumnException(column, (Throwable)e));
        }
    }
}

