/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.resultset;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import uk.org.ogsadai.converters.resultset.ResultSetHandler;
import uk.org.ogsadai.converters.resultset.ResultSetHandlerException;

public class ResultSetConverter {
    private static final String COPYRIGHT_NOTICE = "(c) The University of Edinburgh 2002 - 2006.";
    private final ResultSet mResultSet;
    private final ResultSetHandler mHandler;
    private StringBuffer mBlock;
    private boolean mHeader = true;
    private boolean mFooter = true;

    public ResultSetConverter(ResultSet results, ResultSetHandler handler) {
        if (results == null) {
            throw new IllegalArgumentException("results must not be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler must not be null");
        }
        this.mResultSet = results;
        this.mHandler = handler;
    }

    public boolean hasNext() throws ResultSetHandlerException {
        if (this.mHeader) {
            this.processNextBlock();
        }
        return this.mBlock != null;
    }

    public String next() throws ResultSetHandlerException {
        if (this.hasNext()) {
            StringBuffer block = this.mBlock;
            this.processNextBlock();
            return block.toString();
        }
        throw new NoSuchElementException();
    }

    private void processNextBlock() throws ResultSetHandlerException {
        StringBuffer strbuf = this.createStringBuffer();
        try {
            if (this.mHeader) {
                this.mHeader = false;
                this.mHandler.header(strbuf, this.mResultSet);
                this.mBlock = strbuf;
            } else if (this.mFooter && this.mResultSet.next()) {
                this.processRow(strbuf);
                this.mBlock = strbuf;
            } else if (this.mFooter) {
                this.mFooter = false;
                this.mHandler.footer(strbuf);
                this.mBlock = strbuf;
            } else {
                this.mBlock = null;
            }
        }
        catch (SQLException e) {
            throw new ResultSetHandlerException(e);
        }
    }

    private void processRow(StringBuffer strbuf) throws ResultSetHandlerException {
        try {
            this.mHandler.rowStart(strbuf);
            int columns = this.mResultSet.getMetaData().getColumnCount();
            for (int column = 1; column <= columns; ++column) {
                this.mHandler.columnStart(strbuf);
                this.mHandler.field(strbuf, this.mResultSet, column);
                this.mHandler.columnEnd(strbuf);
            }
            this.mHandler.rowEnd(strbuf);
        }
        catch (SQLException e) {
            throw new ResultSetHandlerException(e);
        }
    }

    protected StringBuffer createStringBuffer() {
        return new StringBuffer();
    }
}

