/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.databaseschema.toxml;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import uk.org.ogsadai.converters.databaseschema.ColumnMetaData;
import uk.org.ogsadai.converters.databaseschema.ColumnMetaDataImpl;
import uk.org.ogsadai.converters.databaseschema.KeyMetaData;
import uk.org.ogsadai.converters.databaseschema.KeyMetaDataImpl;
import uk.org.ogsadai.converters.databaseschema.ResultSetTableMetaDataException;
import uk.org.ogsadai.converters.databaseschema.TableMetaData;

public class TableMetaDataImpl
implements TableMetaData {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";
    private String mName;
    private String mSchema;
    private String mCatalog;
    private ColumnMetaData[] mColumns;
    private Set mPrimaryKeys = new HashSet();
    private Set mImportedKeys = new HashSet();
    private Set mExportedKeys = new HashSet();
    public static final String JDBC_COL_NAME = "COLUMN_NAME";
    public static final String JDBC_COL_POSITION = "ORDINAL_POSITION";
    public static final String JDBC_COL_DATA_TYPE = "DATA_TYPE";
    public static final String JDBC_COL_TYPE_NAME = "TYPE_NAME";
    public static final String JDBC_COL_SIZE = "COLUMN_SIZE";
    public static final String JDBC_COL_DEC_DIGITS = "DECIMAL_DIGITS";
    public static final String JDBC_FK_TABLE = "FKTABLE_NAME";
    public static final String JDBC_FK_SCHEMA = "FKTABLE_SCHEM";
    public static final String JDBC_FK_CATALOG = "FKTABLE_CAT";
    public static final String JDBC_FK_COL = "FKCOLUMN_NAME";
    public static final String JDBC_PK_TABLE = "PKTABLE_NAME";
    public static final String JDBC_PK_COL = "PKCOLUMN_NAME";

    public TableMetaDataImpl(String catalog, String schema, String name) {
        this.mName = name;
        this.mSchema = schema;
        this.mCatalog = catalog;
    }

    public void setPrimaryKeys(ResultSet primaryKeys) throws ResultSetTableMetaDataException {
        if (primaryKeys == null) {
            return;
        }
        try {
            while (primaryKeys.next()) {
                this.mPrimaryKeys.add(primaryKeys.getString(JDBC_COL_NAME));
            }
        }
        catch (SQLException e) {
            throw new ResultSetTableMetaDataException(this.mCatalog, this.mSchema, this.mName, e);
        }
    }

    public void setImportedKeys(ResultSet importedKeys) throws ResultSetTableMetaDataException {
        this.setKeys(importedKeys, this.mImportedKeys);
    }

    public void setExportedKeys(ResultSet exportedKeys) throws ResultSetTableMetaDataException {
        this.setKeys(exportedKeys, this.mExportedKeys);
    }

    private void setKeys(ResultSet keys, Set keySet) throws ResultSetTableMetaDataException {
        try {
            while (keys.next()) {
                KeyMetaDataImpl key = new KeyMetaDataImpl();
                key.setPrimaryKeyTableName(keys.getString(JDBC_PK_TABLE));
                key.setPrimaryKeyColumnName(keys.getString(JDBC_PK_COL));
                key.setForeignTable(keys.getString(JDBC_FK_TABLE), keys.getString(JDBC_FK_SCHEMA), keys.getString(JDBC_FK_CATALOG));
                key.setForeignColumnName(keys.getString(JDBC_FK_COL));
                keySet.add(key);
            }
        }
        catch (SQLException e) {
            throw new ResultSetTableMetaDataException(this.mCatalog, this.mSchema, this.mName, e);
        }
    }

    public void setColumns(ResultSet columns) throws ResultSetTableMetaDataException {
        HashSet<ColumnMetaDataImpl> columnSet = new HashSet<ColumnMetaDataImpl>();
        try {
            while (columns.next()) {
                ColumnMetaDataImpl column = new ColumnMetaDataImpl(columns.getString(JDBC_COL_NAME), columns.getInt(JDBC_COL_POSITION), this);
                column.setFullName(this.mName + "_" + column.getName());
                column.setDataType(columns.getInt(JDBC_COL_DATA_TYPE));
                column.setTypeName(columns.getString(JDBC_COL_TYPE_NAME));
                column.setColumnSize(columns.getInt(JDBC_COL_SIZE));
                column.setDecimalDigits(columns.getInt(JDBC_COL_DEC_DIGITS));
                columnSet.add(column);
            }
        }
        catch (SQLException e) {
            throw new ResultSetTableMetaDataException(this.mCatalog, this.mSchema, this.mName, e);
        }
        this.mColumns = new ColumnMetaData[columnSet.size()];
        Iterator iter = columnSet.iterator();
        while (iter.hasNext()) {
            ColumnMetaData element;
            this.mColumns[element.getPosition() - 1] = element = (ColumnMetaData)iter.next();
        }
    }

    public String getName() {
        return this.mName;
    }

    public String getSchemaName() {
        return this.mSchema;
    }

    public String getCatalogName() {
        return this.mCatalog;
    }

    public ColumnMetaData getColumn(int column) {
        if (this.mColumns == null) {
            return null;
        }
        if (column > this.mColumns.length || column < 1) {
            throw new IllegalArgumentException("column must be > 0 and <= " + this.mColumns.length);
        }
        return this.mColumns[column - 1];
    }

    public int getColumnCount() {
        if (this.mColumns == null) {
            return 0;
        }
        return this.mColumns.length;
    }

    public String[] getPrimaryKeys() {
        if (this.mPrimaryKeys == null) {
            return null;
        }
        return this.mPrimaryKeys.toArray(new String[this.mPrimaryKeys.size()]);
    }

    public KeyMetaData[] getImportedKeys() {
        if (this.mImportedKeys == null) {
            return null;
        }
        return this.mImportedKeys.toArray(new KeyMetaDataImpl[this.mImportedKeys.size()]);
    }

    public KeyMetaData[] getExportedKeys() {
        if (this.mExportedKeys == null) {
            return null;
        }
        return this.mExportedKeys.toArray(new KeyMetaDataImpl[this.mExportedKeys.size()]);
    }
}

