/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.databaseschema.toxml;

import uk.org.ogsadai.converters.databaseschema.ColumnMetaData;
import uk.org.ogsadai.converters.databaseschema.KeyMetaData;
import uk.org.ogsadai.converters.databaseschema.StoredProcedureMetaData;
import uk.org.ogsadai.converters.databaseschema.TableMetaData;
import uk.org.ogsadai.converters.databaseschema.toxml.SchemaConverter;

public class SchemaToXMLConverter
implements SchemaConverter {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";

    public void writeHeader(StringBuffer header) {
        header.append("<");
        header.append("databaseSchema");
        header.append(" xmlns=\"");
        header.append("http://ogsadai.org.uk/namespaces/2005/10/properties");
        header.append("\">\n");
        header.append("<");
        header.append("logicalSchema");
        header.append(">\n");
    }

    public void writeFooter(StringBuffer footer) {
        footer.append("</");
        footer.append("logicalSchema");
        footer.append(">\n");
        footer.append("</");
        footer.append("databaseSchema");
        footer.append(">\n");
    }

    public void writeTable(StringBuffer schema, TableMetaData table) {
        schema.append("<");
        schema.append("table");
        schema.append(" ");
        schema.append("name");
        schema.append("=\"");
        schema.append(table.getName());
        schema.append("\" ");
        schema.append("schema");
        schema.append("=\"");
        schema.append(table.getSchemaName());
        schema.append("\" ");
        schema.append("catalog");
        schema.append("=\"");
        schema.append(table.getCatalogName());
        schema.append("\">\n");
        this.addColumns(table, schema);
        this.addPrimaryKeys(table.getPrimaryKeys(), schema);
        this.addImportedKeys(table.getImportedKeys(), schema);
        this.addExportedKeys(table.getExportedKeys(), schema);
        schema.append("</table>\n");
    }

    public void writeProcedures(StringBuffer output, StoredProcedureMetaData procedures) {
    }

    private void addColumns(TableMetaData table, StringBuffer schema) {
        int count = table.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            ColumnMetaData column = table.getColumn(i);
            schema.append("<");
            schema.append("column");
            schema.append(" ");
            schema.append("name");
            schema.append("=\"");
            schema.append(column.getName());
            schema.append("\" ");
            schema.append("fullName");
            schema.append("=\"");
            schema.append(column.getTable().getName() + "_" + column.getName());
            schema.append("\" ");
            schema.append("length");
            schema.append("=\"");
            schema.append(column.getColumnSize());
            schema.append("\" ");
            schema.append("position");
            schema.append("=\"");
            schema.append(column.getPosition());
            schema.append("\">");
            schema.append("<");
            schema.append("sqlTypeName");
            schema.append(">");
            schema.append(column.getSQLType());
            schema.append("</");
            schema.append("sqlTypeName");
            schema.append(">");
            schema.append("<");
            schema.append("sqlJavaTypeID");
            schema.append(">");
            schema.append(column.getDataType());
            schema.append("</");
            schema.append("sqlJavaTypeID");
            schema.append(">");
            schema.append("</");
            schema.append("column");
            schema.append(">\n");
        }
    }

    private void addPrimaryKeys(String[] keys, StringBuffer output) {
        if (keys == null || keys.length == 0) {
            return;
        }
        output.append("<");
        output.append("primaryKey");
        output.append(">\n");
        for (int i = 0; i < keys.length; ++i) {
            output.append("<");
            output.append("columnName");
            output.append(">");
            output.append(keys[i]);
            output.append("</");
            output.append("columnName");
            output.append(">\n");
        }
        output.append("</");
        output.append("primaryKey");
        output.append(">\n");
    }

    private void addImportedKeys(KeyMetaData[] keys, StringBuffer schema) {
        if (keys == null) {
            return;
        }
        for (int i = 0; i < keys.length; ++i) {
            schema.append("<");
            schema.append("importedKey");
            schema.append(" ");
            schema.append("FKTableName");
            schema.append("=\"");
            schema.append(keys[i].getForeignTableName());
            schema.append("\" ");
            schema.append("FKColumnName");
            schema.append("=\"");
            schema.append(keys[i].getForeignColumnName());
            schema.append("\" ");
            schema.append("PKTableName");
            schema.append("=\"");
            schema.append(keys[i].getPrimaryKeyTableName());
            schema.append("\" ");
            schema.append("PKColumnName");
            schema.append("=\"");
            schema.append(keys[i].getPrimaryKeyColumnName());
            schema.append("\"/>\n");
        }
    }

    private void addExportedKeys(KeyMetaData[] keys, StringBuffer schema) {
        if (keys == null) {
            return;
        }
        for (int i = 0; i < keys.length; ++i) {
            schema.append("<");
            schema.append("exportedKey");
            schema.append(" ");
            schema.append("FKTableName");
            schema.append("=\"");
            schema.append(keys[i].getForeignTableName());
            schema.append("\" ");
            schema.append("FKColumnName");
            schema.append("=\"");
            schema.append(keys[i].getForeignColumnName());
            schema.append("\" ");
            schema.append("PKTableName");
            schema.append("=\"");
            schema.append(keys[i].getPrimaryKeyTableName());
            schema.append("\" ");
            schema.append("PKColumnName");
            schema.append("=\"");
            schema.append(keys[i].getPrimaryKeyColumnName());
            schema.append("\"/>\n");
        }
    }
}

