/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.databaseschema.fromxml;

import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.converters.databaseschema.DatabaseSchemaMetaData;
import uk.org.ogsadai.converters.databaseschema.RelationalSchemaParseException;
import uk.org.ogsadai.converters.databaseschema.fromxml.TableMetaDataImpl;

public class XMLToSchemaConverter {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";
    public static final String DATABASE_SCHEMA_ELT = "databaseSchema";
    public static final String LOGICAL_SCHEMA_ELT = "logicalSchema";

    public static DatabaseSchemaMetaData convert(Element schema) throws RelationalSchemaParseException {
        if (!schema.getNamespaceURI().equals("http://ogsadai.org.uk/namespaces/2005/10/properties") || !schema.getLocalName().equals(DATABASE_SCHEMA_ELT)) {
            throw new RelationalSchemaParseException(DATABASE_SCHEMA_ELT.toString());
        }
        Element logicalSchema = XMLToSchemaConverter.getLogicalSchemaElement(schema);
        DatabaseSchemaMetaData metadata = new DatabaseSchemaMetaData();
        NodeList tables = logicalSchema.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/properties", "table");
        if (tables != null) {
            String[] tableNames = new String[tables.getLength()];
            HashMap<String, TableMetaDataImpl> tableMetaData = new HashMap<String, TableMetaDataImpl>();
            for (int i = 0; i < tables.getLength(); ++i) {
                Element currentTable = (Element)tables.item(i);
                TableMetaDataImpl table = new TableMetaDataImpl(currentTable);
                tableMetaData.put(table.getName(), table);
                tableNames[i] = table.getName();
            }
            metadata.setTableNames(tableNames);
            metadata.setTables(tableMetaData);
        }
        return metadata;
    }

    private static Element getLogicalSchemaElement(Element databaseSchema) throws RelationalSchemaParseException {
        NodeList logicalSchemaElements = databaseSchema.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/properties", LOGICAL_SCHEMA_ELT);
        if (logicalSchemaElements.getLength() < 1) {
            throw new RelationalSchemaParseException(LOGICAL_SCHEMA_ELT.toString());
        }
        return (Element)logicalSchemaElements.item(0);
    }
}

