/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.databaseschema.fromxml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.converters.databaseschema.ColumnMetaData;
import uk.org.ogsadai.converters.databaseschema.ColumnMetaDataImpl;
import uk.org.ogsadai.converters.databaseschema.KeyMetaData;
import uk.org.ogsadai.converters.databaseschema.KeyMetaDataImpl;
import uk.org.ogsadai.converters.databaseschema.TableMetaData;

public class TableMetaDataImpl
implements TableMetaData {
    private static final String COPYRIGHT_NOTICE = "(c) University of Edinburgh 2002 - 2005.";
    private String mName;
    private String mSchema;
    private String mCatalog;
    private ColumnMetaData[] mColumns;
    private Set mPrimaryKeys = new HashSet();
    private KeyMetaData[] mImportedKeys;
    private KeyMetaData[] mExportedKeys;
    private Map mColumnMap = new HashMap();

    public TableMetaDataImpl(Element table) {
        this.mName = table.getAttribute("name");
        if (table.hasAttribute("schema")) {
            this.mSchema = table.getAttribute("schema");
        }
        if (table.hasAttribute("catalog")) {
            this.mCatalog = table.getAttribute("catalog");
        }
        NodeList columns = table.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/properties", "column");
        this.mColumns = new ColumnMetaData[columns.getLength()];
        for (int j = 0; j < columns.getLength(); ++j) {
            String name = columns.item(j).getAttributes().getNamedItem("name").getNodeValue();
            this.mColumnMap.put(name, new Integer(j));
            ColumnMetaDataImpl column = new ColumnMetaDataImpl(name, j, this);
            column.setFullName(columns.item(j).getAttributes().getNamedItem("fullName").getNodeValue());
            column.setTypeName(((Element)columns.item(j)).getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/properties", "sqlTypeName").item(0).getFirstChild().getNodeValue());
            column.setDataType(Integer.parseInt(((Element)columns.item(j)).getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/properties", "sqlJavaTypeID").item(0).getFirstChild().getNodeValue()));
            column.setColumnSize(Integer.parseInt(columns.item(j).getAttributes().getNamedItem("length").getNodeValue()));
            this.mColumns[j] = column;
        }
        NodeList primaryKeyList = table.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/properties", "primaryKey");
        if (primaryKeyList != null && primaryKeyList.getLength() != 0) {
            NodeList primaryKeyColumns = ((Element)primaryKeyList.item(0)).getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2005/10/properties", "columnName");
            for (int j = 0; j < primaryKeyColumns.getLength(); ++j) {
                String key = primaryKeyColumns.item(j).getFirstChild().getNodeValue();
                int columnNumber = (Integer)this.mColumnMap.get(key);
                ((ColumnMetaDataImpl)this.mColumns[columnNumber]).setPrimaryKey(true);
                this.mPrimaryKeys.add(key);
            }
        }
        this.mImportedKeys = this.parseKeys(table, "importedKey");
        this.mExportedKeys = this.parseKeys(table, "exportedKey");
    }

    private KeyMetaData[] parseKeys(Element schema, String elementName) {
        NodeList keys = schema.getElementsByTagName(elementName);
        if (keys == null || keys.getLength() == 0) {
            return null;
        }
        KeyMetaData[] result = new KeyMetaData[keys.getLength()];
        for (int i = 0; i < keys.getLength(); ++i) {
            Element currentKey = (Element)keys.item(i);
            KeyMetaDataImpl key = new KeyMetaDataImpl();
            key.setForeignTable(null, null, currentKey.getAttribute("FKTableName"));
            key.setForeignColumnName(currentKey.getAttribute("FKColumnName"));
            key.setPrimaryKeyTableName(currentKey.getAttribute("PKTableName"));
            key.setPrimaryKeyColumnName(currentKey.getAttribute("PKColumnName"));
            result[i] = key;
        }
        return result;
    }

    public String getName() {
        return this.mName;
    }

    public String getSchemaName() {
        return this.mSchema;
    }

    public String getCatalogName() {
        return this.mCatalog;
    }

    public int getColumnCount() {
        return this.mColumns.length;
    }

    public ColumnMetaData getColumn(int index) {
        return this.mColumns[index];
    }

    public String[] getPrimaryKeys() {
        return this.mPrimaryKeys.toArray(new String[this.mPrimaryKeys.size()]);
    }

    public KeyMetaData[] getImportedKeys() {
        return this.mImportedKeys;
    }

    public KeyMetaData[] getExportedKeys() {
        return this.mExportedKeys;
    }
}

