/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.csv.resultset.types;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import uk.org.ogsadai.common.Base64;
import uk.org.ogsadai.common.BinaryLob;
import uk.org.ogsadai.common.CharacterLob;
import uk.org.ogsadai.converters.csv.resultset.types.TypeStrategy;

public class StringToAllStrategy
extends TypeStrategy {
    private static final String COPYRIGHT_NOTICE = "(c) The University of Edinburgh 2002 - 2005.";

    public String getString(String data) {
        return data;
    }

    public InputStream getAsciiStream(String data) {
        if (data == null) {
            return null;
        }
        return new ByteArrayInputStream(data.getBytes());
    }

    public BigDecimal getBigDecimal(String data) throws SQLException {
        if (data == null) {
            return null;
        }
        try {
            return new BigDecimal(data);
        }
        catch (NumberFormatException e) {
            throw new SQLException("Cannot convert " + data + " to BigDecimal");
        }
    }

    public InputStream getBinaryStream(String data) {
        if (data == null) {
            return null;
        }
        return new ByteArrayInputStream(data.getBytes());
    }

    public BigInteger getBigInteger(String data) throws SQLException {
        if (data == null) {
            return null;
        }
        try {
            return new BigInteger(data);
        }
        catch (NumberFormatException e) {
            throw new SQLException("Cannot convert " + data + " to BigInteger");
        }
    }

    public boolean getBoolean(String data) throws SQLException {
        if (data == null) {
            return false;
        }
        return new Boolean(data);
    }

    public byte[] getBytes(String data) {
        if (data == null) {
            return null;
        }
        return data.getBytes();
    }

    public byte[] getBytes64(String data) {
        if (data == null) {
            return null;
        }
        return new Base64().decode(data.getBytes());
    }

    public Reader getCharacterStream(String data) throws SQLException {
        if (data == null) {
            return null;
        }
        return new StringReader(data);
    }

    public Date getDate(String data) throws SQLException {
        if (data == null) {
            return null;
        }
        try {
            return Date.valueOf(data);
        }
        catch (IllegalArgumentException e) {
            try {
                return new Date(Long.parseLong(data));
            }
            catch (NumberFormatException e1) {
                throw new SQLException("Cannot convert " + data + " to long");
            }
        }
    }

    public short getShort(String data) throws SQLException {
        short result = 0;
        if (data != null) {
            try {
                result = Short.parseShort(data);
            }
            catch (NumberFormatException e) {
                throw new SQLException("Cannot convert " + data + " to short");
            }
        }
        return result;
    }

    public int getInt(String data) throws SQLException {
        int result = 0;
        if (data != null) {
            try {
                result = Integer.parseInt(data);
            }
            catch (NumberFormatException e) {
                throw new SQLException("Cannot convert " + data + " to int");
            }
        }
        return result;
    }

    public long getLong(String data) throws SQLException {
        long result = 0L;
        if (data != null) {
            try {
                result = Long.parseLong(data);
            }
            catch (NumberFormatException e) {
                throw new SQLException("Cannot convert " + data + " to long");
            }
        }
        return result;
    }

    public double getDouble(String data) throws SQLException {
        double result = 0.0;
        if (data != null) {
            try {
                result = Double.parseDouble(data);
            }
            catch (NumberFormatException e) {
                throw new SQLException("Cannot convert " + data + " to double");
            }
        }
        return result;
    }

    public float getFloat(String data) throws SQLException {
        float result = 0.0f;
        if (data != null) {
            try {
                result = Float.parseFloat(data);
            }
            catch (NumberFormatException e) {
                throw new SQLException("Cannot convert " + data + " to float");
            }
        }
        return result;
    }

    public Timestamp getTimestamp(String data) throws SQLException {
        if (data == null) {
            return null;
        }
        try {
            return Timestamp.valueOf(data);
        }
        catch (IllegalArgumentException e) {
            try {
                return new Timestamp(Long.parseLong(data));
            }
            catch (NumberFormatException e1) {
                throw new SQLException("Cannot convert " + data + " to long");
            }
        }
    }

    public Time getTime(String data) throws SQLException {
        if (data == null) {
            return null;
        }
        try {
            return Time.valueOf(data);
        }
        catch (IllegalArgumentException e) {
            try {
                return new Time(Long.parseLong(data));
            }
            catch (NumberFormatException e1) {
                throw new SQLException("Cannot convert " + data + " to long");
            }
        }
    }

    public Object getObject(String data) {
        return this.getString(data);
    }

    public Blob getBlob(String data) throws SQLException {
        if (data == null) {
            return null;
        }
        BinaryLob blob = new BinaryLob();
        blob.setBytes(1L, new Base64().decode(data.getBytes()));
        return blob;
    }

    public Clob getClob(String data) throws SQLException {
        if (data == null) {
            return null;
        }
        CharacterLob clob = new CharacterLob();
        clob.setString(1L, data);
        return clob;
    }
}

