/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.csv.resultset;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Vector;
import uk.org.ogsadai.converters.csv.resultset.AbstractResultSet;

public class ResultSetScrollable
extends AbstractResultSet {
    private static final String COPYRIGHT_NOTICE = "(c) The University of Edinburgh 2002 - 2005.";
    private LinkedList mData = new LinkedList();
    private int mLast = -1;
    private int mCursor = -1;
    private Vector mCurrentRow;

    public synchronized void putRow(Vector row) {
        if (row != null) {
            this.mData.addLast(row);
        } else {
            this.mLast = this.mData.size() - 1;
            this.mCursor = -1;
            this.notifyAll();
        }
    }

    public boolean next() {
        if (this.mCursor < this.mLast) {
            ++this.mCursor;
            this.mCurrentRow = (Vector)this.mData.get(this.mCursor);
            return true;
        }
        this.mCursor = this.mLast + 1;
        this.mCurrentRow = null;
        return false;
    }

    public Vector getCurrentRow() {
        return this.mCurrentRow;
    }

    public void beforeFirst() {
        this.mCursor = -1;
    }

    public void afterLast() throws SQLException {
        this.mCursor = this.mLast + 1;
        this.mCurrentRow = null;
    }

    protected String getColumn(int column) throws SQLException {
        if (this.mCurrentRow != null) {
            return (String)this.mCurrentRow.get(column - 1);
        }
        throw new SQLException("No current row");
    }

    public int getRow() throws SQLException {
        return this.mCursor + 1;
    }

    public int getType() throws SQLException {
        return 1004;
    }

    public boolean first() throws SQLException {
        this.mCursor = 0;
        this.mCurrentRow = (Vector)this.mData.getFirst();
        return this.mLast >= 0;
    }

    public boolean isAfterLast() throws SQLException {
        return this.mCursor > this.mLast;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.mCursor < 0;
    }

    public boolean isFirst() throws SQLException {
        return this.mCursor == 0;
    }

    public boolean isLast() throws SQLException {
        return this.mCursor == this.mLast;
    }

    public boolean last() throws SQLException {
        this.mCursor = this.mLast;
        this.mCurrentRow = (Vector)this.mData.getLast();
        return this.mLast > 0;
    }

    public boolean previous() throws SQLException {
        if (this.mCursor > 0) {
            --this.mCursor;
            this.mCurrentRow = (Vector)this.mData.get(this.mCursor);
            return true;
        }
        this.mCursor = -1;
        this.mCurrentRow = null;
        return false;
    }

    public boolean absolute(int row) throws SQLException {
        if (row > 0 && row <= this.mLast + 1) {
            this.mCursor = row - 1;
            this.mCurrentRow = (Vector)this.mData.get(this.mCursor);
            return true;
        }
        if (row < 0 && this.mLast + row + 1 >= 0) {
            this.mCursor = this.mLast + row + 1;
            this.mCurrentRow = (Vector)this.mData.get(this.mCursor);
            return true;
        }
        if (row == 0) {
            this.mCursor = 0;
        } else if (row > this.mLast) {
            this.mCursor = this.mLast + 1;
        }
        this.mCurrentRow = null;
        return false;
    }

    public boolean relative(int arg0) throws SQLException {
        return false;
    }
}

