/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.csv.resultset;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Vector;
import uk.org.ogsadai.converters.csv.resultset.AbstractResultSet;
import uk.org.ogsadai.converters.webrowset.SQLWrappedException;

public class ResultSetForwardOnly
extends AbstractResultSet {
    private static final String COPYRIGHT_NOTICE = "(c) The University of Edinburgh 2002 - 2005.";
    private int mBufferSize = 100;
    private LinkedList mBuffer = new LinkedList();
    private boolean mClosed = false;
    private Vector mCurrentRow;
    private int mCursor = 0;
    private Throwable mError = null;

    public synchronized void setError(Throwable error) {
        this.mError = error;
        this.notifyAll();
    }

    public Throwable getError() {
        return this.mError;
    }

    public synchronized void putMetaData(ResultSetMetaData metadata) throws SQLException {
        super.putMetaData(metadata);
        this.notifyAll();
    }

    public synchronized void putRow(Vector row) {
        if (row == null) {
            this.mClosed = true;
            this.notifyAll();
            return;
        }
        if (this.mBuffer.size() > this.mBufferSize) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.mBuffer.addLast(row);
        this.notifyAll();
    }

    public synchronized boolean next() throws SQLException {
        while (this.mBuffer.size() == 0 && !this.mClosed && this.mError == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.notifyAll();
        if (this.mBuffer.size() == 0) {
            if (this.mError != null) {
                throw new SQLWrappedException(this.mError);
            }
            if (this.mClosed) {
                return false;
            }
        }
        this.mCurrentRow = (Vector)this.mBuffer.removeFirst();
        ++this.mCursor;
        return true;
    }

    public void setBufferSize(int size) {
        this.mBufferSize = size;
    }

    public int getBufferSize() {
        return this.mBufferSize;
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        while (this.mMetaData == null && this.mError == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.mError != null) {
            throw new SQLWrappedException(this.mError);
        }
        return this.mMetaData;
    }

    protected Vector getCurrentRow() {
        return this.mCurrentRow;
    }

    protected String getColumn(int column) {
        return (String)this.mCurrentRow.get(column - 1);
    }

    public int getRow() throws SQLException {
        return this.mCursor;
    }

    public int getType() throws SQLException {
        return 1003;
    }

    public void afterLast() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void beforeFirst() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean first() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isAfterLast() throws SQLException {
        return this.mClosed;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.mCursor == 0;
    }

    public boolean isFirst() throws SQLException {
        return this.mCursor == 1;
    }

    public boolean isLast() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean last() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean previous() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean absolute(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean relative(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

