/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.csv.resultset;

import java.io.IOException;
import java.io.Reader;
import java.sql.ResultSet;
import java.sql.SQLException;
import uk.org.ogsadai.converters.csv.CSVConfigurator;
import uk.org.ogsadai.converters.csv.CSVParseException;
import uk.org.ogsadai.converters.csv.CSVParser;
import uk.org.ogsadai.converters.csv.resultset.ResultSetForwardOnly;
import uk.org.ogsadai.converters.csv.resultset.ResultSetScrollable;
import uk.org.ogsadai.exception.DAIIOException;

public class CSVToResultSet {
    private static final String COPYRIGHT_NOTICE = "(c) The University of Edinburgh 2002 - 2005.";
    private int mType = 1003;
    private Reader mInput;
    private CSVConfigurator mConfigurator = new CSVConfigurator();

    public CSVToResultSet(Reader reader) {
        this.mInput = reader;
    }

    public void setConfigurator(CSVConfigurator configurator) {
        if (configurator != null) {
            this.mConfigurator = configurator;
        }
    }

    public void setResultSetType(int type) throws IllegalArgumentException {
        if (type != 1004 && type != 1003) {
            throw new IllegalArgumentException("type must be one of ResultSet.TYPE_SCROLL_INSENSITIVE or ResultSet.TYPE_FORWARD_ONLY");
        }
        this.mType = type;
    }

    public ResultSet getResultSet() throws SQLException, DAIIOException, CSVParseException {
        final CSVParser parser = new CSVParser();
        parser.setInput(this.mInput);
        parser.setConfigurator(this.mConfigurator);
        if (this.mType == 1004) {
            ResultSetScrollable resultSet = new ResultSetScrollable();
            parser.setOutput(resultSet);
            try {
                parser.parse();
                return resultSet;
            }
            catch (IOException e) {
                throw new DAIIOException(e);
            }
        }
        final ResultSetForwardOnly resultSet = new ResultSetForwardOnly();
        parser.setOutput(resultSet);
        Thread thread = new Thread(){

            public void run() {
                try {
                    parser.parse();
                }
                catch (IOException e) {
                    resultSet.setError(new DAIIOException(e));
                }
                catch (Throwable e) {
                    resultSet.setError(e);
                }
            }
        };
        thread.start();
        return resultSet;
    }
}

