/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.csv;

import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import java.util.Vector;
import uk.org.ogsadai.converters.csv.CSVConfigurator;
import uk.org.ogsadai.converters.csv.CSVHandler;
import uk.org.ogsadai.converters.csv.CSVParseException;
import uk.org.ogsadai.converters.csv.metadata.CSVColumnMetaData;

public class CSVParser {
    private static final String COPYRIGHT_NOTICE = "(c) The University of Edinburgh 2002 - 2005.";
    private boolean dblQuoteOpen = false;
    private boolean dblQuoteMayClose = false;
    private Reader mInput;
    private CSVHandler mOutput;
    private CSVConfigurator mConfigurator;
    private CSVColumnMetaData mMetaData = new CSVColumnMetaData();

    public void setConfigurator(CSVConfigurator configurator) {
        this.mConfigurator = configurator;
    }

    public void setInput(Reader reader) {
        this.mInput = reader;
    }

    public void setOutput(CSVHandler handler) {
        this.mOutput = handler;
    }

    public void parse() throws CSVParseException, IOException, SQLException {
        CSVReader csvReader = new CSVReader();
        while (csvReader.next()) {
            char charRead = csvReader.getChar();
            if (charRead == '\"') {
                if (!this.dblQuoteOpen) {
                    this.dblQuoteOpen = true;
                    csvReader.nextFieldInDblQuotes();
                    continue;
                }
                if (!this.dblQuoteMayClose) {
                    this.dblQuoteMayClose = true;
                    continue;
                }
                csvReader.nextFieldIncludesDblQuotes();
                this.dblQuoteMayClose = false;
                continue;
            }
            if (charRead == this.mConfigurator.getMDelimiter().charAt(0)) {
                if (!this.dblQuoteOpen) {
                    csvReader.addField(false);
                    continue;
                }
                if (!this.dblQuoteMayClose) continue;
                csvReader.addField(false);
                this.dblQuoteMayClose = false;
                this.dblQuoteOpen = false;
                continue;
            }
            if (charRead != this.mConfigurator.getMLineBreakChars().charAt(0)) continue;
            boolean isLineBreak = true;
            if (this.mConfigurator.getMLineBreakChars().length() == 2) {
                if (!csvReader.next()) break;
                charRead = csvReader.getChar();
                if (charRead != this.mConfigurator.getMLineBreakChars().charAt(1)) {
                    isLineBreak = false;
                }
            }
            if (!isLineBreak) continue;
            if (!this.dblQuoteOpen) {
                csvReader.addRow(true);
                continue;
            }
            if (!this.dblQuoteMayClose) continue;
            csvReader.addRow(true);
            this.dblQuoteMayClose = false;
            this.dblQuoteOpen = false;
        }
        this.mOutput.putRow(null);
    }

    private void storeColumnNames(CSVColumnMetaData metadata, Vector row) {
        for (int i = 0; i < row.size(); ++i) {
            metadata.setColumnName(i + 1, (String)row.get(i));
        }
    }

    private class CSVReader {
        private int BUFFER_SIZE = 9000;
        private int fieldStart = 0;
        private int cursorIdx = -1;
        private char[] charBlock;
        private char[] charBlockTemp;
        private int charsInCharBlock;
        private boolean nextFieldInDblQuotes = false;
        private boolean nextFieldIncludesDblQuotes = false;
        private int numberOfColumns = -1;
        private int numberOfRows = 0;
        private boolean headerParsed = false;
        private Vector recordFields = new Vector();

        protected boolean next() throws IOException, CSVParseException, SQLException {
            if (this.charBlock == null) {
                this.charBlock = new char[this.BUFFER_SIZE];
                this.charsInCharBlock = CSVParser.this.mInput.read(this.charBlock);
            }
            ++this.cursorIdx;
            if (this.cursorIdx == this.charsInCharBlock) {
                if (this.charBlockTemp == null) {
                    this.charBlockTemp = new char[this.BUFFER_SIZE];
                }
                if (this.cursorIdx - this.fieldStart == this.BUFFER_SIZE) {
                    this.BUFFER_SIZE *= 2;
                    this.charBlockTemp = new char[this.BUFFER_SIZE];
                }
                System.arraycopy(this.charBlock, this.fieldStart, this.charBlockTemp, 0, this.cursorIdx - this.fieldStart);
                this.charBlock = this.charBlockTemp;
                this.cursorIdx -= this.fieldStart;
                int charsRead = CSVParser.this.mInput.read(this.charBlock, this.cursorIdx, this.BUFFER_SIZE - this.cursorIdx);
                this.charsInCharBlock = charsRead != -1 ? this.cursorIdx + charsRead : -1;
                this.fieldStart = 0;
            } else if (this.charsInCharBlock == -1) {
                if (this.recordFields.size() > 0) {
                    --this.cursorIdx;
                    this.addRow(false);
                }
                if (this.numberOfRows == 0) {
                    this.numberOfColumns = this.recordFields.size();
                    CSVParser.this.mMetaData.setColumnCount(this.numberOfColumns);
                    CSVParser.this.mOutput.putMetaData(CSVParser.this.mMetaData);
                }
                CSVParser.this.mInput.close();
                this.charBlock = null;
                return false;
            }
            return true;
        }

        protected char getChar() {
            return this.charBlock[this.cursorIdx];
        }

        protected void addField(boolean lineBreak) {
            String field = lineBreak ? new String(this.charBlock, this.fieldStart, this.cursorIdx - this.fieldStart - (CSVParser.this.mConfigurator.getMLineBreakChars().length() - 1)) : new String(this.charBlock, this.fieldStart, this.cursorIdx - this.fieldStart);
            if (this.nextFieldInDblQuotes) {
                field = this.extractFromDblQuotes(field);
            }
            if (field.equals(CSVParser.this.mConfigurator.getMNullDataStr())) {
                this.recordFields.add(null);
            } else {
                this.recordFields.add(field);
            }
            this.fieldStart = this.cursorIdx + 1;
        }

        protected void addRow(boolean lineBreak) throws CSVParseException, SQLException {
            this.addField(lineBreak);
            if (this.numberOfColumns == -1) {
                this.numberOfColumns = this.recordFields.size();
                CSVParser.this.mMetaData.setColumnCount(this.numberOfColumns);
            }
            if (this.recordFields.size() != this.numberOfColumns) {
                if (this.recordFields.size() != 1 || !((String)this.recordFields.get(0)).matches("[ ]*")) {
                    throw new CSVParseException();
                }
            } else if (!this.headerParsed && CSVParser.this.mConfigurator.isMIncludeHeader()) {
                CSVParser.this.storeColumnNames(CSVParser.this.mMetaData, this.recordFields);
                this.headerParsed = true;
                CSVParser.this.mOutput.putMetaData(CSVParser.this.mMetaData);
            } else {
                ++this.numberOfRows;
                CSVParser.this.mOutput.putRow(this.recordFields);
            }
            this.recordFields = new Vector();
            this.fieldStart = this.cursorIdx + 1;
        }

        private String extractFromDblQuotes(String field) {
            field = field.substring(1, field.length() - 1);
            if (this.nextFieldIncludesDblQuotes) {
                field = field.replaceAll("\"\"", "\"");
                this.nextFieldIncludesDblQuotes = false;
            }
            this.nextFieldInDblQuotes = false;
            return field;
        }

        public void nextFieldIncludesDblQuotes() {
            this.nextFieldIncludesDblQuotes = true;
        }

        public void nextFieldInDblQuotes() {
            this.nextFieldInDblQuotes = true;
        }
    }
}

