/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.csv;

import uk.org.ogsadai.converters.csv.CSVConfigurationException;

public class CSVConfigurator {
    private static final String COPYRIGHT_NOTICE = "(c) The University of Edinburgh 2002 - 2005.";
    private String mLineBreakChars = "\n";
    private String mLineBreak = "CR";
    private String mDelimiter = ",";
    private String mNullDataStr = "NULL";
    private boolean mIncludeHeader = true;
    private boolean mEscapeFields = true;

    public String getMLineBreakChars() {
        return this.mLineBreakChars;
    }

    public String getMLineBreak() {
        return this.mLineBreak;
    }

    /*
     * WARNING - void declaration
     */
    public void setMLineBreak(String lineBreak) throws CSVConfigurationException {
        void var2_2;
        String lineBreakChars;
        if (lineBreak.equals("CR")) {
            lineBreakChars = "\n";
        } else if (lineBreak.equals("LF")) {
            lineBreakChars = "\r";
        } else if (lineBreak.equals("LFCR")) {
            lineBreakChars = "\r\n";
        } else {
            throw new CSVConfigurationException();
        }
        if (var2_2.equals(this.mDelimiter) || var2_2.equals(this.mNullDataStr)) {
            throw new CSVConfigurationException();
        }
        this.mLineBreak = lineBreak;
        this.mLineBreakChars = var2_2;
    }

    public String getMNullDataStr() {
        return this.mNullDataStr;
    }

    public void setMNullDataStr(String nullDataStr) throws CSVConfigurationException {
        if (nullDataStr.equals(this.mDelimiter) || nullDataStr.equals(this.mLineBreakChars) || nullDataStr.matches(".*[\"].*")) {
            throw new CSVConfigurationException();
        }
        this.mNullDataStr = nullDataStr;
    }

    public boolean isMIncludeHeader() {
        return this.mIncludeHeader;
    }

    public void setMIncludeHeader(boolean includeHeader) {
        this.mIncludeHeader = includeHeader;
    }

    public String getMDelimiter() {
        return this.mDelimiter;
    }

    public void setMDelimiter(String delimiter) throws CSVConfigurationException {
        if (delimiter.equals(this.mLineBreakChars) || delimiter.equals(this.mNullDataStr) || delimiter.equals("\"") || delimiter.length() != 1) {
            throw new CSVConfigurationException();
        }
        this.mDelimiter = delimiter;
    }

    public boolean isMEscapeFields() {
        return this.mEscapeFields;
    }

    public void setMEscapeFields(boolean escapeFields) {
        this.mEscapeFields = escapeFields;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("lineBreak:\t" + this.mLineBreak + "\n");
        sb.append("delimiter:\t" + this.mDelimiter + "\n");
        sb.append("nullDataStr:\t" + this.mNullDataStr + "\n");
        sb.append("includeHeader:\t" + this.mIncludeHeader + "\n");
        sb.append("escapeFields:\t" + this.mEscapeFields + "\n");
        return sb.toString();
    }
}

