/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import uk.org.ogsadai.common.StringUtils;
import uk.org.ogsadai.common.files.DAIFileException;
import uk.org.ogsadai.common.files.FileUtilities;
import uk.org.ogsadai.common.xml.SimpleErrorHandler;
import uk.org.ogsadai.common.xml.XMLDocumentException;
import uk.org.ogsadai.common.xml.XMLEmptyElementException;
import uk.org.ogsadai.common.xml.XMLFileException;
import uk.org.ogsadai.common.xml.XMLMissingAttributeException;
import uk.org.ogsadai.common.xml.XMLMissingElementException;
import uk.org.ogsadai.common.xml.XMLParseException;
import uk.org.ogsadai.exception.ExternalModuleException;

public class XMLUtilities {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2006. (c) University of Edinburgh 2002 - 2006.";

    public static Document xmlFileToDOM(String fileName) throws XMLFileException, XMLDocumentException, XMLParseException {
        return XMLUtilities.xmlFileToDOM(fileName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document xmlFileToDOM(String fileName, boolean validate) throws XMLFileException, XMLDocumentException, XMLParseException {
        Document doc = null;
        try {
            InputStream is = FileUtilities.openStreamFromFile(fileName);
            try {
                doc = XMLUtilities.xmlStreamToDOM(is, validate);
            }
            finally {
                FileUtilities.closeStreamFromFile(fileName, is);
            }
        }
        catch (DAIFileException fileEx) {
            throw new XMLFileException(fileName, fileEx);
        }
        return doc;
    }

    public static Document xmlStringToDOM(String str) throws XMLDocumentException, XMLParseException {
        return XMLUtilities.xmlStringToDOM(str, true);
    }

    public static Document xmlStringToDOM(String str, boolean validate) throws XMLDocumentException, XMLParseException {
        if (str == null) {
            throw new IllegalArgumentException("str must not be null");
        }
        return XMLUtilities.xmlStreamToDOM(new ByteArrayInputStream(str.getBytes()), validate);
    }

    public static Document xmlStreamToDOM(InputStream stream) throws XMLDocumentException, XMLParseException {
        return XMLUtilities.xmlStreamToDOM(stream, true);
    }

    public static Document xmlStreamToDOM(InputStream stream, boolean validate) throws XMLDocumentException, XMLParseException {
        if (stream == null) {
            throw new IllegalArgumentException("stream must not be null");
        }
        Document returnDoc = null;
        try {
            DOMParser pxml = new DOMParser();
            pxml.setErrorHandler((ErrorHandler)new SimpleErrorHandler());
            pxml.setFeature("http://apache.org/xml/features/validation/schema", validate);
            pxml.setFeature("http://xml.org/sax/features/validation", validate);
            pxml.setFeature("http://xml.org/sax/features/namespaces", true);
            pxml.setFeature("http://apache.org/xml/features/validation/warn-on-duplicate-attdef", true);
            pxml.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", false);
            pxml.parse(new InputSource(stream));
            returnDoc = pxml.getDocument();
            returnDoc.normalize();
            return returnDoc;
        }
        catch (SAXNotRecognizedException e) {
            throw new ExternalModuleException(e);
        }
        catch (SAXNotSupportedException e) {
            throw new ExternalModuleException(e);
        }
        catch (SAXParseException e) {
            throw new XMLDocumentException(e);
        }
        catch (SAXException e) {
            throw new XMLParseException(e);
        }
        catch (IOException e) {
            throw new XMLParseException(e);
        }
    }

    public static Document xmlReaderToDOM(Reader reader, boolean validate) throws XMLDocumentException, XMLParseException {
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        Document returnDoc = null;
        try {
            DOMParser pxml = new DOMParser();
            pxml.setErrorHandler((ErrorHandler)new SimpleErrorHandler());
            pxml.setFeature("http://apache.org/xml/features/validation/schema", validate);
            pxml.setFeature("http://xml.org/sax/features/validation", validate);
            pxml.setFeature("http://xml.org/sax/features/namespaces", true);
            pxml.setFeature("http://apache.org/xml/features/validation/warn-on-duplicate-attdef", true);
            pxml.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", false);
            pxml.parse(new InputSource(reader));
            returnDoc = pxml.getDocument();
            returnDoc.normalize();
            return returnDoc;
        }
        catch (SAXNotRecognizedException e) {
            throw new ExternalModuleException(e);
        }
        catch (SAXNotSupportedException e) {
            throw new ExternalModuleException(e);
        }
        catch (SAXParseException e) {
            throw new XMLDocumentException(e);
        }
        catch (SAXException e) {
            throw new XMLParseException(e);
        }
        catch (IOException e) {
            throw new XMLParseException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void xmlDOMToFile(Document doc, String fileName) throws XMLFileException, XMLParseException {
        try {
            OutputStream os = FileUtilities.openStreamToFile(fileName);
            try {
                XMLUtilities.xmlDOMToStream((Node)doc, new OutputStreamWriter(os));
            }
            finally {
                FileUtilities.closeStreamToFile(fileName, os);
            }
        }
        catch (DAIFileException fileEx) {
            throw new XMLFileException(fileName, fileEx);
        }
    }

    public static String xmlDOMToString(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node must not be null");
        }
        StringWriter sw = new StringWriter();
        try {
            XMLUtilities.xmlDOMToStream(node, null, sw);
        }
        catch (XMLParseException xMLParseException) {
            // empty catch block
        }
        return sw.toString();
    }

    public static void xmlDOMToStream(Node node, OutputStream stream) throws XMLParseException {
        if (node == null) {
            throw new IllegalArgumentException("node must not be null");
        }
        if (stream == null) {
            throw new IllegalArgumentException("stream must not be null");
        }
        XMLUtilities.xmlDOMToStream(node, stream, null);
    }

    public static void xmlDOMToStream(Node node, Writer writer) throws XMLParseException {
        if (node == null) {
            throw new IllegalArgumentException("node must not be null");
        }
        if (writer == null) {
            throw new IllegalArgumentException("writer must not be null");
        }
        XMLUtilities.xmlDOMToStream(node, null, writer);
    }

    private static void xmlDOMToStream(Node node, OutputStream stream, Writer writer) throws XMLParseException {
        OutputFormat o = new OutputFormat("xml", "UTF-8", true);
        o.setLineWidth(0);
        XMLSerializer s = null;
        if (stream != null) {
            s = new XMLSerializer(stream, o);
        } else if (writer != null) {
            s = new XMLSerializer(writer, o);
        }
        s.setNamespaces(true);
        try {
            if (node instanceof Document) {
                s.serialize((Document)node);
            } else if (node instanceof DocumentFragment) {
                s.serialize((DocumentFragment)node);
            } else if (node instanceof Element) {
                s.serialize((Element)node);
            }
        }
        catch (IOException e) {
            throw new XMLParseException(e);
        }
    }

    public static String getTextContent(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node must not be null");
        }
        StringBuffer s = new StringBuffer();
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n.getNodeType() != 3 && n.getNodeType() != 4) continue;
            CharacterData data = (CharacterData)n;
            s.append(data.getData());
        }
        return (String)StringUtils.removeDuplicateWhitespace(s.toString().trim());
    }

    public static Iterator getChildElementIterator(Node parent) {
        if (parent == null) {
            throw new IllegalArgumentException("parent must not be null");
        }
        NodeList nodes = parent.getChildNodes();
        ArrayList<Node> elements = new ArrayList<Node>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            elements.add(node);
        }
        return elements.iterator();
    }

    public static Document createEmptyDocument() throws ExternalModuleException {
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new ExternalModuleException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new ExternalModuleException(e);
        }
        return document;
    }

    public static String replaceSpecialCharacters(String input) {
        input = input.replaceAll("&", "&amp;");
        input = input.replaceAll(">", "&gt;");
        input = input.replaceAll("<", "&lt;");
        input = input.replaceAll("\"", "&quot;");
        input = input.replaceAll("'", "&apos;");
        return input;
    }

    public static Element getElement(Document doc, String eltName) {
        if (doc == null) {
            throw new IllegalArgumentException("Doc must not be null");
        }
        if (eltName == null) {
            throw new IllegalArgumentException("eltName must not be null");
        }
        Element result = null;
        NodeList elts = doc.getDocumentElement().getElementsByTagName(eltName);
        if (elts.getLength() > 0) {
            result = (Element)elts.item(0);
        }
        return result;
    }

    public static String getElementValue(Document doc, String eltName) {
        if (doc == null) {
            throw new IllegalArgumentException("Doc must not be null");
        }
        if (eltName == null) {
            throw new IllegalArgumentException("eltName must not be null");
        }
        String result = null;
        Element element = XMLUtilities.getElement(doc, eltName);
        if (element != null) {
            result = element.getChildNodes().item(0).getNodeValue();
        }
        return result;
    }

    public static String getAttributeValue(Document doc, String eltName, String attributeName) {
        Element elt;
        Attr attribute;
        if (doc == null) {
            throw new IllegalArgumentException("Doc must not be null");
        }
        if (eltName == null) {
            throw new IllegalArgumentException("eltName must not be null");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("attributeName must not be null");
        }
        String result = null;
        NodeList elts = doc.getDocumentElement().getElementsByTagName(eltName);
        if (elts.getLength() > 0 && (attribute = (elt = (Element)elts.item(0)).getAttributeNode(attributeName)) != null) {
            result = attribute.getNodeValue();
        }
        return result;
    }

    public static long parseLong(Element parent, String childName, String attributeName) {
        Element child;
        if (parent == null) {
            throw new IllegalArgumentException("parent element must not be null");
        }
        if (childName == null) {
            throw new IllegalArgumentException("childName must not be null");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("attributeName must not be null");
        }
        long value = -1L;
        NodeList children = parent.getElementsByTagName(childName);
        if (children.getLength() > 0 && (child = (Element)children.item(0)).hasAttribute(attributeName)) {
            try {
                value = Long.parseLong(child.getAttribute(attributeName));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return value;
    }

    public static String parseElementValue(Element element, boolean nonEmpty) throws XMLEmptyElementException, XMLParseException {
        String value = XMLUtilities.getChildText(element);
        if (nonEmpty && (value == null || value.length() == 0)) {
            throw new XMLEmptyElementException(element.getLocalName());
        }
        return value;
    }

    public static String parseChildElementValue(Element parent, String namespaceURI, String childName, boolean required, boolean nonEmpty) throws XMLEmptyElementException, XMLMissingElementException, XMLParseException {
        String value = null;
        Element child = XMLUtilities.getChildElement(parent, namespaceURI, childName);
        if (child == null) {
            if (required) {
                throw new XMLMissingElementException(childName);
            }
        } else {
            value = XMLUtilities.parseElementValue(child, nonEmpty);
        }
        return value;
    }

    public static String parseAttribute(Element element, String attributeName, boolean nonEmpty) throws XMLMissingAttributeException, XMLParseException {
        String value = element.getAttribute(attributeName);
        if (nonEmpty && value.length() == 0) {
            throw new XMLMissingAttributeException(attributeName, element.getLocalName());
        }
        return value;
    }

    public static String parseChildElementAttribute(Element parent, String namespaceURI, String childName, String attributeName, boolean required, boolean nonEmpty) throws XMLEmptyElementException, XMLMissingElementException, XMLMissingAttributeException, XMLParseException {
        String value = null;
        Element child = XMLUtilities.getChildElement(parent, namespaceURI, childName);
        if (child == null) {
            if (required) {
                throw new XMLMissingElementException(childName);
            }
        } else {
            value = XMLUtilities.parseAttribute(child, attributeName, nonEmpty);
        }
        return value;
    }

    public static List getChildElements(Element parent) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            list.add((Element)node);
        }
        return list;
    }

    public static Element getChildElement(Element parent, String namespaceURI, String childName) {
        Element child = null;
        NodeList elements = parent.getElementsByTagNameNS(namespaceURI, childName);
        if (elements.getLength() > 0) {
            child = (Element)elements.item(0);
        }
        return child;
    }

    public static String getChildElementAttribute(Element parent, String namespaceURI, String childName, String attributeName) {
        Element child = XMLUtilities.getChildElement(parent, namespaceURI, childName);
        return child.getAttribute(attributeName);
    }

    public static String getChildText(Element parent, String namespaceURI, String childName) throws XMLParseException {
        String text = null;
        Element child = XMLUtilities.getChildElement(parent, namespaceURI, childName);
        if (child != null) {
            text = XMLUtilities.getChildText(child);
        }
        return text;
    }

    public static String getChildText(Node parent) throws XMLParseException {
        StringBuffer textBuffer = new StringBuffer();
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 3 || child.getNodeType() == 4) {
                textBuffer.append(child.getNodeValue());
                continue;
            }
            if (child.getNodeType() != 1) continue;
            textBuffer.append(XMLUtilities.elementToString((Element)child));
        }
        return textBuffer.toString().trim();
    }

    public static String elementToString(Element element) throws XMLParseException {
        StringWriter writer = new StringWriter();
        OutputFormat format = new OutputFormat("xml", "UTF-8", true);
        format.setOmitXMLDeclaration(true);
        XMLSerializer serializer = new XMLSerializer((Writer)writer, format);
        serializer.setNamespaces(true);
        try {
            serializer.serialize(element);
        }
        catch (IOException e) {
            throw new XMLParseException(e);
        }
        return writer.toString();
    }
}

