/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.SchemaEntityResolver;
import uk.org.ogsadai.common.xml.SimpleErrorHandler;
import uk.org.ogsadai.common.xml.XMLDocumentException;
import uk.org.ogsadai.common.xml.XMLParseException;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.exception.DAIMalformedURLException;
import uk.org.ogsadai.exception.ExternalModuleException;

public class XMLSchemaUtilities {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005";
    private static final DAILogger LOG = DAILogger.getLogger(XMLSchemaUtilities.class);

    public static void merge(Document dest, Document src) {
        NamedNodeMap map = src.getDocumentElement().getAttributes();
        int mapSize = map.getLength();
        for (int i = 0; i < mapSize; ++i) {
            Attr attribute = (Attr)map.item(i);
            String uri = attribute.getNamespaceURI();
            if (uri == null || !uri.equals("http://www.w3.org/2000/xmlns/")) continue;
            Attr newAttribute = (Attr)dest.importNode(attribute, false);
            dest.getDocumentElement().setAttributeNode(newAttribute);
        }
        NodeList nodes = src.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = dest.importNode(nodes.item(i), true);
            dest.getDocumentElement().appendChild(node);
        }
    }

    public static void makeSchemaLocationsAbsolute(Document doc, URL base) throws DAIMalformedURLException {
        NodeList list = doc.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "schema");
        if (list.getLength() > 0) {
            Element schema = (Element)list.item(0);
            NodeList includes = schema.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "include");
            String schemaLocation = null;
            try {
                for (int i = 0; i < includes.getLength(); ++i) {
                    Element include = (Element)includes.item(i);
                    schemaLocation = include.getAttribute("schemaLocation");
                    URL url = new URL(base, schemaLocation);
                    include.setAttribute("schemaLocation", url.toString());
                }
            }
            catch (MalformedURLException e) {
                throw new DAIMalformedURLException(base.toString(), schemaLocation);
            }
        }
    }

    public static void makeSchemaLocationsAbsolute(Document doc, String base) throws DAIMalformedURLException {
        try {
            URL url = new URL(base);
            XMLSchemaUtilities.makeSchemaLocationsAbsolute(doc, url);
        }
        catch (MalformedURLException e) {
            throw new DAIMalformedURLException(base);
        }
    }

    public static void removeAllIncludes(Document doc) {
        NodeList list = doc.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "schema");
        if (list.getLength() > 0) {
            Element schema = (Element)list.item(0);
            NodeList includes = schema.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "include");
            for (int i = 0; i < includes.getLength(); ++i) {
                Element include = (Element)includes.item(i);
                doc.getDocumentElement().removeChild(include);
            }
        }
    }

    public static void removeIncludes(Document doc, URL schemaLocation) {
        NodeList list = doc.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "schema");
        if (list.getLength() > 0) {
            Element schema = (Element)list.item(0);
            NodeList includes = schema.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "include");
            for (int i = 0; i < includes.getLength(); ++i) {
                Element include = (Element)includes.item(i);
                String locationString = include.getAttribute("schemaLocation");
                try {
                    URL location = new URL(locationString);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Comparing schemaLocations: " + schemaLocation + " : " + location);
                    }
                    if (!schemaLocation.sameFile(location)) continue;
                    doc.getDocumentElement().removeChild(include);
                    continue;
                }
                catch (MalformedURLException e) {
                    DAIMalformedURLException ex = new DAIMalformedURLException(locationString);
                    LOG.warn(ex);
                }
            }
        }
    }

    public static void removeIncludes(Document doc, String schemaLocation) throws DAIMalformedURLException {
        try {
            URL url = new URL(schemaLocation);
            XMLSchemaUtilities.removeIncludes(doc, url);
        }
        catch (MalformedURLException e) {
            throw new DAIMalformedURLException(schemaLocation);
        }
    }

    public static void validate(Document document, Document schema) throws XMLDocumentException, XMLParseException {
        try {
            Element element = document.getDocumentElement();
            String oldSchemaLocation = element.hasAttribute("xsi:schemaLocation") ? element.getAttribute("xsi:schemaLocation") : null;
            String oldXMLNS = element.hasAttribute("xmlns") ? element.getAttribute("xmlns") : null;
            String oldXSI = element.hasAttribute("xmlns:xsi") ? element.getAttribute("xmlns:xsi") : null;
            document.getDocumentElement().setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            String targetNamespace = schema.getDocumentElement().getAttribute("targetNamespace");
            document.getDocumentElement().setAttribute("xsi:schemaLocation", targetNamespace + " " + targetNamespace);
            document.getDocumentElement().setAttribute("xmlns", targetNamespace);
            DOMParser pxml = new DOMParser();
            pxml.setFeature("http://apache.org/xml/features/validation/schema", true);
            pxml.setFeature("http://xml.org/sax/features/validation", true);
            pxml.setFeature("http://xml.org/sax/features/namespaces", true);
            pxml.setFeature("http://apache.org/xml/features/validation/warn-on-duplicate-attdef", true);
            pxml.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", false);
            pxml.setErrorHandler((ErrorHandler)new SimpleErrorHandler());
            pxml.setEntityResolver((EntityResolver)new SchemaEntityResolver(schema));
            InputSource input = new InputSource(new ByteArrayInputStream(XMLUtilities.xmlDOMToString(document).getBytes()));
            pxml.parse(input);
            if (oldSchemaLocation == null) {
                element.removeAttribute("xsi:schemaLocation");
            } else {
                element.setAttribute("xsi:schemaLocation", oldSchemaLocation);
            }
            if (oldXMLNS == null) {
                element.removeAttribute("xmlns");
            } else {
                element.setAttribute("xmlns", oldXMLNS);
            }
            if (oldXSI == null) {
                element.removeAttribute("xmlns:xsi");
            } else {
                element.setAttribute("xmlns:xsi", oldXMLNS);
            }
        }
        catch (SAXNotRecognizedException e) {
            throw new ExternalModuleException(e);
        }
        catch (SAXNotSupportedException e) {
            throw new ExternalModuleException(e);
        }
        catch (SAXParseException e) {
            throw new XMLDocumentException(e);
        }
        catch (SAXException e) {
            throw new XMLParseException(e);
        }
        catch (IOException e) {
            throw new XMLParseException(e);
        }
    }
}

