/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.xml.XMLUtilities;

class SchemaEntityResolver
implements EntityResolver {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private static final DAILogger LOG = DAILogger.getLogger(SchemaEntityResolver.class);
    private final String mNamespace;
    private final String mSchema;

    SchemaEntityResolver(Document schema) {
        if (schema == null) {
            throw new IllegalArgumentException("Schema must not be null");
        }
        this.mNamespace = schema.getDocumentElement().getAttribute("targetNamespace");
        this.mSchema = XMLUtilities.xmlDOMToString(schema);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Constructed with schema namespace = " + this.mNamespace);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource input = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resolving entity: publicId = " + publicId + ", systemId = " + systemId);
        }
        if (publicId != null && publicId.equals(this.mNamespace) || systemId != null && systemId.equals(this.mNamespace)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Successfully resolved to XSD schema in memory.");
            }
            input = new InputSource(new ByteArrayInputStream(this.mSchema.getBytes()));
        } else {
            URL url = null;
            if (systemId != null) {
                url = new URL(systemId);
            } else if (publicId != null) {
                url = new URL(publicId);
            }
            if (url != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Successfully resolved to URL");
                }
                input = new InputSource(url.openStream());
            }
        }
        return input;
    }
}

