/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common.serializer;

import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.encoding.DeserializerFactory;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.message.MessageElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.serializer.DAISerializationException;
import uk.org.ogsadai.common.serializer.DAIUnregisteredSerializationException;
import uk.org.ogsadai.common.serializer.DAIUnsupportedSerializationException;

public class SerializerUtils {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005";
    private static final DAILogger LOG = DAILogger.getLogger(SerializerUtils.class);

    public static MessageElement[] toMessage(QName name, Object value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entered SerializerUtils.toMessage() Name: " + name + " Value: " + value);
        }
        MessageElement messageElement = new MessageElement(name, value);
        messageElement.setType(Constants.XSD_ANYTYPE);
        QName type = null;
        if (value instanceof QName) {
            type = Constants.XSD_QNAME;
        } else if (value instanceof byte[]) {
            type = Constants.XSD_BASE64;
        } else if (value instanceof String) {
            type = Constants.XSD_STRING;
        } else if (value instanceof Integer) {
            type = Constants.XSD_INTEGER;
        } else if (value instanceof Float) {
            type = Constants.XSD_FLOAT;
        } else if (value instanceof Long) {
            type = Constants.XSD_LONG;
        } else if (value instanceof Boolean) {
            type = Constants.XSD_BOOLEAN;
        } else if (value instanceof Integer) {
            type = Constants.XSD_INTEGER;
        }
        if (type != null) {
            messageElement.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", type);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exiting SerializerUtils.toMessage(). First MessageElement is " + messageElement.toString());
        }
        return new MessageElement[]{messageElement};
    }

    public static Object toObject(MessageElement[] elements) throws DAISerializationException {
        if (elements == null) {
            return null;
        }
        if (elements.length < 1) {
            return null;
        }
        return SerializerUtils.toObject(elements[0]);
    }

    public static Object toObject(MessageElement element) throws DAISerializationException {
        Object value;
        MessageContext context;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Entered SerializerUtils.toObject() MessageElement: " + element);
        }
        if (element == null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("SerializerUtils.toObject() MessageElement: " + element.toString());
        }
        if ((context = MessageContext.getCurrentContext()) != null) {
            try {
                DeserializerFactory obj = context.getTypeMapping().getDeserializer(element.getType());
                if (obj == null) {
                    element.setType(element.getQName());
                }
            }
            catch (JAXRPCException e) {
                DAIUnregisteredSerializationException ex = new DAIUnregisteredSerializationException(element.getType(), e);
                throw new DAISerializationException(element.toString(), ex);
            }
            catch (IllegalArgumentException e) {
                DAIUnsupportedSerializationException ex = new DAIUnsupportedSerializationException(element.getType());
                throw new DAISerializationException(element.toString(), ex);
            }
        }
        if ((value = element.getObjectValue()) == null) {
            value = SerializerUtils.toElement(element);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exiting SerializerUtils.toObject() Object: " + value);
        }
        return value;
    }

    public static Document toDocument(MessageElement[] elements) throws DAISerializationException {
        if (elements == null) {
            return null;
        }
        if (elements.length < 1) {
            return null;
        }
        return SerializerUtils.toDocument(elements[0]);
    }

    public static Document toDocument(MessageElement element) throws DAISerializationException {
        return SerializerUtils.toElement(element).getOwnerDocument();
    }

    public static Element[] toElement(MessageElement[] elements) throws DAISerializationException {
        if (elements == null) {
            return null;
        }
        if (elements.length < 1) {
            return null;
        }
        int numElts = elements.length;
        Element[] elts = new Element[numElts];
        for (int i = 0; i < numElts; ++i) {
            elts[i] = SerializerUtils.toElement(elements[i]);
        }
        return elts;
    }

    public static Element toElement(MessageElement element) throws DAISerializationException {
        try {
            return element.getAsDOM();
        }
        catch (Exception e) {
            throw new DAISerializationException(element.toString(), e);
        }
    }
}

