/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common.rolemap;

import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.common.files.DAIFileContentError;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.rolemap.Cryptography;
import uk.org.ogsadai.common.rolemap.CryptographyException;
import uk.org.ogsadai.common.rolemap.DatabaseRole;
import uk.org.ogsadai.common.rolemap.Role;
import uk.org.ogsadai.common.rolemap.RoleMapAuthorizationException;
import uk.org.ogsadai.common.rolemap.RoleMapCannotAuthorizeException;
import uk.org.ogsadai.common.rolemap.RoleMapConfigurationException;
import uk.org.ogsadai.common.rolemap.RoleMapper;
import uk.org.ogsadai.common.xml.XMLParseException;
import uk.org.ogsadai.common.xml.XMLUtilities;
import uk.org.ogsadai.exception.DAIException;

public class SimpleFileWithEncryptedPasswordsRoleMapper
implements RoleMapper {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002-4. (c) University of Edinburgh 2002-4.";
    private static DAILogger LOG = DAILogger.getLogger(SimpleFileWithEncryptedPasswordsRoleMapper.class);
    private static final String WILDCARD = "*";
    private static boolean VALIDATE = true;
    Map mDBHash = new Hashtable();

    public void setConfiguration(String filename) throws RoleMapConfigurationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Attempting to load role map file: " + filename);
        }
        Document roleMapData = null;
        File configurationFile = new File(filename);
        try {
            roleMapData = XMLUtilities.xmlFileToDOM(filename, VALIDATE);
        }
        catch (XMLParseException e) {
            DAIFileContentError error = new DAIFileContentError(configurationFile, (Throwable)e);
            throw new RoleMapConfigurationException(error);
        }
        catch (DAIException e) {
            throw new RoleMapConfigurationException(e);
        }
        if (roleMapData != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Clearing existing roleMaps!");
            }
            this.mDBHash.clear();
            NodeList baseList = roleMapData.getChildNodes();
            for (int i = 0; i < baseList.getLength(); ++i) {
                Node currentBaseNode = baseList.item(i);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Base node " + currentBaseNode.getLocalName());
                }
                if (currentBaseNode.getNodeType() != 1 || !currentBaseNode.getLocalName().equals("DatabaseRoles")) continue;
                NodeList childList = currentBaseNode.getChildNodes();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Number of DataBase nodes: " + childList.getLength());
                }
                for (int j = 0; j < childList.getLength(); ++j) {
                    Node dbNameAttribute;
                    Node currentNode = childList.item(j);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Database node " + currentNode.getLocalName());
                    }
                    if (currentNode.getNodeType() != 1 || !currentNode.getLocalName().equals("Database") || (dbNameAttribute = currentNode.getAttributes().getNamedItem("name")) == null) continue;
                    this.addDatabaseRoles(dbNameAttribute.getNodeValue(), currentNode.getChildNodes());
                }
            }
        }
    }

    private void addDatabaseRoles(String databaseName, NodeList userList) {
        Hashtable<String, DatabaseRole> dbTable = new Hashtable<String, DatabaseRole>();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding database: " + databaseName);
        }
        this.mDBHash.put(databaseName, dbTable);
        for (int i = 0; i < userList.getLength(); ++i) {
            Node currentNode = userList.item(i);
            if (currentNode.getNodeType() != 1 || !currentNode.getLocalName().equals("User")) continue;
            NamedNodeMap userAttributes = currentNode.getAttributes();
            Node dnAttribute = userAttributes.getNamedItem("dn");
            Node useridAttribute = userAttributes.getNamedItem("userid");
            Node passwordAttribute = userAttributes.getNamedItem("encryptedPassword");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding database role map DB: " + databaseName + " Credential: " + dnAttribute.getNodeValue());
            }
            if (dnAttribute == null || useridAttribute == null || passwordAttribute == null) continue;
            dbTable.put(dnAttribute.getNodeValue(), new DatabaseRole(useridAttribute.getNodeValue(), passwordAttribute.getNodeValue()));
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Added database rolemap DB: " + databaseName + " Credential: " + dnAttribute.getNodeValue() + " User: " + useridAttribute.getNodeValue());
        }
    }

    public Role map(String credentials, String database) throws RoleMapAuthorizationException, RoleMapCannotAuthorizeException {
        DatabaseRole role = null;
        Map dbTable = (Map)this.mDBHash.get(database);
        if (dbTable != null && (role = (DatabaseRole)dbTable.get(credentials)) == null) {
            role = (DatabaseRole)dbTable.get(WILDCARD);
        }
        if (role == null) {
            throw new RoleMapAuthorizationException(credentials, database);
        }
        String decryptedPassword = null;
        try {
            decryptedPassword = Cryptography.unscramble(role.getPassword());
        }
        catch (CryptographyException e) {
            throw new RoleMapCannotAuthorizeException(e);
        }
        return new DatabaseRole(role.getUserId(), decryptedPassword);
    }
}

