/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common.rolemap;

import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.org.ogsadai.common.files.FileUtilities;
import uk.org.ogsadai.common.rolemap.Cryptography;

public class DecryptRoleMapperFile {
    private static final String COPYRIGHT_NOTICE = "(c) IBM Corp. 2002 - 2005. (c) University of Edinburgh 2002 - 2005.";
    private String mFilename;
    private String mPassword;

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("Usage:\n  java uk.org.ogsadai.common.rolemap.DecryptRoleMapperFile <password> <file>");
            System.exit(1);
        }
        DecryptRoleMapperFile decrypter = new DecryptRoleMapperFile(args[0], args[1]);
        String output = decrypter.decrypt();
        decrypter.writeToFile(output);
    }

    public DecryptRoleMapperFile(String password, String filename) {
        this.mPassword = password;
        this.mFilename = filename;
    }

    public void writeToFile(String contents) throws Exception {
        FileUtilities.deleteFile(this.mFilename);
        FileUtilities.writeStringToFile(this.mFilename, contents);
    }

    public String decrypt() throws Exception {
        String contents = FileUtilities.readStringFromFile(this.mFilename);
        StringBuffer buf = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(contents, ">");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            Pattern pattern = Pattern.compile("(.*)encryptedPassword(\\s*=\\s*\")(.*)(\".*)", 40);
            Matcher matcher = pattern.matcher(token);
            if (matcher.matches()) {
                buf.append(matcher.group(1));
                buf.append("password");
                buf.append(matcher.group(2));
                buf.append(Cryptography.unscramble(this.mPassword, matcher.group(3)));
                buf.append(matcher.group(4));
            } else {
                buf.append(token);
            }
            if (!tokenizer.hasMoreTokens()) continue;
            buf.append(">");
        }
        return buf.toString();
    }
}

